/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ResourceLoader {
    private ResourceLoader() {
    }

    public static InputStream loadResource(String resourceName) throws IOException {
        File f;
        ClassLoader loader = ResourceLoader.class.getClassLoader();
        InputStream is = null;
        if (loader != null) {
            is = loader.getResourceAsStream(resourceName);
        }
        if (is == null && (loader = ClassLoader.getSystemClassLoader()) != null) {
            is = loader.getResourceAsStream(resourceName);
        }
        if (is == null && (f = new File(resourceName)).exists()) {
            is = new FileInputStream(f);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String resourceName) throws IOException {
        Properties properties = null;
        InputStream is = null;
        try {
            is = ResourceLoader.loadResource(resourceName);
            if (is != null) {
                properties = new Properties();
                properties.load(is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String resourceName, Properties defaults) throws IOException {
        InputStream is = null;
        try {
            is = ResourceLoader.loadResource(resourceName);
            if (is != null) {
                defaults.load(is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return defaults;
    }
}

