/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDChoiceButton;

public class PDCheckbox
extends PDChoiceButton {
    private static final COSName KEY = COSName.getPDFName("AS");
    private static final COSName OFF_VALUE = COSName.getPDFName("Off");
    private COSName value;

    public PDCheckbox(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
        COSDictionary ap = (COSDictionary)field.getDictionaryObject(COSName.getPDFName("AP"));
        if (ap != null) {
            COSBase n = ap.getDictionaryObject(COSName.getPDFName("N"));
            if (n instanceof COSDictionary) {
                List li = ((COSDictionary)n).keyList();
                for (int i = 0; i < li.size(); ++i) {
                    COSName name = (COSName)li.get(i);
                    if (name.equals(OFF_VALUE)) continue;
                    this.value = name;
                }
            }
        } else {
            this.value = (COSName)this.getDictionary().getDictionaryObject("V");
        }
    }

    public boolean isChecked() {
        boolean retval = false;
        String onValue = this.getOnValue();
        COSName radioValue = (COSName)this.getDictionary().getDictionaryObject(KEY);
        if (radioValue != null && this.value != null && radioValue.getName().equals(onValue)) {
            retval = true;
        }
        return retval;
    }

    public void check() {
        this.getDictionary().setItem(KEY, (COSBase)this.value);
    }

    public void unCheck() {
        this.getDictionary().setItem(KEY, (COSBase)OFF_VALUE);
    }

    public void setValue(String newValue) {
        this.getDictionary().setName("V", newValue);
        if (newValue == null) {
            this.getDictionary().setItem(KEY, (COSBase)OFF_VALUE);
        } else {
            this.getDictionary().setName(KEY, newValue);
        }
    }

    public String getOffValue() {
        return OFF_VALUE.getName();
    }

    public String getOnValue() {
        String retval = null;
        COSDictionary ap = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.getPDFName("AP"));
        COSBase n = ap.getDictionaryObject(COSName.getPDFName("N"));
        if (n instanceof COSDictionary) {
            for (Object key : ((COSDictionary)n).keyList()) {
                if (key.equals(OFF_VALUE)) continue;
                retval = ((COSName)key).getName();
            }
        }
        return retval;
    }

    public String getValue() throws IOException {
        return this.getDictionary().getNameAsString("V");
    }
}

