/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.encryption;

import java.lang.reflect.Constructor;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.pdfbox.pdmodel.encryption.PublicKeySecurityHandler;
import org.pdfbox.pdmodel.encryption.SecurityHandler;
import org.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.pdfbox.pdmodel.encryption.StandardSecurityHandler;

public class SecurityHandlersManager {
    private static SecurityHandlersManager instance;
    private Hashtable handlerNames = new Hashtable();
    private Hashtable handlerPolicyClasses = new Hashtable();

    private SecurityHandlersManager() {
        try {
            this.registerHandler("Standard", StandardSecurityHandler.class, StandardProtectionPolicy.class);
            this.registerHandler("Adobe.PubSec", PublicKeySecurityHandler.class, PublicKeyProtectionPolicy.class);
        }
        catch (Exception e) {
            System.err.println("SecurityHandlersManager strange error with builtin handlers: " + e.getMessage());
            System.exit(1);
        }
    }

    public void registerHandler(String filterName, Class securityHandlerClass, Class protectionPolicyClass) throws BadSecurityHandlerException {
        if (this.handlerNames.contains(securityHandlerClass) || this.handlerPolicyClasses.contains(securityHandlerClass)) {
            throw new BadSecurityHandlerException("the following security handler was already registered: " + securityHandlerClass.getName());
        }
        if (SecurityHandler.class.isAssignableFrom(securityHandlerClass)) {
            try {
                if (this.handlerNames.containsKey(filterName)) {
                    throw new BadSecurityHandlerException("a security handler was already registered for the filter name " + filterName);
                }
                if (this.handlerPolicyClasses.containsKey(protectionPolicyClass)) {
                    throw new BadSecurityHandlerException("a security handler was already registered for the policy class " + protectionPolicyClass.getName());
                }
                this.handlerNames.put(filterName, securityHandlerClass);
                this.handlerPolicyClasses.put(protectionPolicyClass, securityHandlerClass);
            }
            catch (Exception e) {
                throw new BadSecurityHandlerException(e);
            }
        } else {
            throw new BadSecurityHandlerException("The class is not a super class of SecurityHandler");
        }
    }

    public static SecurityHandlersManager getInstance() {
        if (instance == null) {
            instance = new SecurityHandlersManager();
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        return instance;
    }

    public SecurityHandler getSecurityHandler(ProtectionPolicy policy) throws BadSecurityHandlerException {
        Object found = this.handlerPolicyClasses.get(policy.getClass());
        if (found == null) {
            throw new BadSecurityHandlerException("Cannot find an appropriate security handler for " + policy.getClass().getName());
        }
        Class handlerclass = (Class)found;
        Class[] argsClasses = new Class[]{policy.getClass()};
        Object[] args = new Object[]{policy};
        try {
            Constructor c = handlerclass.getDeclaredConstructor(argsClasses);
            SecurityHandler handler = (SecurityHandler)c.newInstance(args);
            return handler;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadSecurityHandlerException("problem while trying to instanciate the security handler " + handlerclass.getName() + ": " + e.getMessage());
        }
    }

    public SecurityHandler getSecurityHandler(String filterName) throws BadSecurityHandlerException {
        Object found = this.handlerNames.get(filterName);
        if (found == null) {
            throw new BadSecurityHandlerException("Cannot find an appropriate security handler for " + filterName);
        }
        Class handlerclass = (Class)found;
        Class[] argsClasses = new Class[]{};
        Object[] args = new Object[]{};
        try {
            Constructor c = handlerclass.getDeclaredConstructor(argsClasses);
            SecurityHandler handler = (SecurityHandler)c.newInstance(args);
            return handler;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadSecurityHandlerException("problem while trying to instanciate the security handler " + handlerclass.getName() + ": " + e.getMessage());
        }
    }
}

