/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.common.COSDictionaryMap;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.font.PDFontFactory;
import org.pdfbox.pdmodel.graphics.PDExtendedGraphicsState;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDResources
implements COSObjectable {
    private COSDictionary resources;

    public PDResources() {
        this.resources = new COSDictionary();
    }

    public PDResources(COSDictionary resourceDictionary) {
        this.resources = resourceDictionary;
    }

    public COSDictionary getCOSDictionary() {
        return this.resources;
    }

    public COSBase getCOSObject() {
        return this.resources;
    }

    public Map getFonts(Map fontCache) throws IOException {
        COSDictionaryMap retval = null;
        COSDictionary fonts = (COSDictionary)this.resources.getDictionaryObject(COSName.FONT);
        if (fonts == null) {
            fonts = new COSDictionary();
            this.resources.setItem(COSName.FONT, (COSBase)fonts);
        }
        HashMap<String, PDFont> actuals = new HashMap<String, PDFont>();
        retval = new COSDictionaryMap(actuals, fonts);
        for (COSName fontName : fonts.keyList()) {
            COSBase font = fonts.getDictionaryObject(fontName);
            if (!(font instanceof COSDictionary)) continue;
            COSDictionary fontDictionary = (COSDictionary)font;
            actuals.put(fontName.getName(), PDFontFactory.createFont(fontDictionary, fontCache));
        }
        return retval;
    }

    public Map getFonts() throws IOException {
        return this.getFonts(null);
    }

    public Map getXObjects() throws IOException {
        COSDictionaryMap retval = null;
        COSDictionary xobjects = (COSDictionary)this.resources.getDictionaryObject("XObject");
        if (xobjects == null) {
            xobjects = new COSDictionary();
            this.resources.setItem("XObject", (COSBase)xobjects);
        }
        HashMap<String, PDXObject> actuals = new HashMap<String, PDXObject>();
        retval = new COSDictionaryMap(actuals, xobjects);
        for (COSName objName : xobjects.keyList()) {
            COSBase cosObject = xobjects.getDictionaryObject(objName);
            PDXObject xobject = PDXObject.createXObject(cosObject);
            if (xobject == null) continue;
            actuals.put(objName.getName(), xobject);
        }
        return retval;
    }

    public Map getImages() throws IOException {
        COSDictionaryMap retval = null;
        COSDictionary images = (COSDictionary)this.resources.getDictionaryObject("XObject");
        if (images == null) {
            images = new COSDictionary();
            this.resources.setItem("XObject", (COSBase)images);
        }
        HashMap<String, PDXObjectImage> actuals = new HashMap<String, PDXObjectImage>();
        retval = new COSDictionaryMap(actuals, images);
        for (COSName imageName : images.keyList()) {
            PDXObjectImage ximage;
            COSStream image = (COSStream)images.getDictionaryObject(imageName);
            COSName subType = (COSName)image.getDictionaryObject(COSName.SUBTYPE);
            if (!subType.equals(COSName.IMAGE) || (ximage = (PDXObjectImage)PDXObject.createXObject(image)) == null) continue;
            actuals.put(imageName.getName(), ximage);
        }
        return retval;
    }

    public void setFonts(Map fonts) {
        this.resources.setItem(COSName.FONT, (COSBase)COSDictionaryMap.convert(fonts));
    }

    public Map getColorSpaces() throws IOException {
        COSDictionaryMap retval = null;
        COSDictionary colorspaces = (COSDictionary)this.resources.getDictionaryObject(COSName.getPDFName("ColorSpace"));
        if (colorspaces != null) {
            HashMap<String, PDColorSpace> actuals = new HashMap<String, PDColorSpace>();
            retval = new COSDictionaryMap(actuals, colorspaces);
            for (COSName csName : colorspaces.keyList()) {
                COSBase cs = colorspaces.getDictionaryObject(csName);
                actuals.put(csName.getName(), PDColorSpaceFactory.createColorSpace(cs));
            }
        }
        return retval;
    }

    public void setColorSpaces(Map colorspaces) {
        this.resources.setItem(COSName.getPDFName("ColorSpace"), (COSBase)COSDictionaryMap.convert(colorspaces));
    }

    public Map getGraphicsStates() {
        COSDictionaryMap retval = null;
        COSDictionary states = (COSDictionary)this.resources.getDictionaryObject(COSName.getPDFName("ExtGState"));
        if (states != null) {
            HashMap<String, PDExtendedGraphicsState> actuals = new HashMap<String, PDExtendedGraphicsState>();
            retval = new COSDictionaryMap(actuals, states);
            for (COSName name : states.keyList()) {
                COSDictionary dictionary = (COSDictionary)states.getDictionaryObject(name);
                actuals.put(name.getName(), new PDExtendedGraphicsState(dictionary));
            }
        }
        return retval;
    }

    public void setGraphicsStates(Map states) {
        Iterator iter = states.keySet().iterator();
        COSDictionary dic = new COSDictionary();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            PDExtendedGraphicsState state = (PDExtendedGraphicsState)states.get(name);
            dic.setItem(COSName.getPDFName(name), state.getCOSObject());
        }
        this.resources.setItem(COSName.getPDFName("ExtGState"), (COSBase)dic);
    }
}

