/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.awt.geom.Rectangle2D;
import java.util.List;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.pdfbox.util.PDFTextStripperByArea;

public class PrintURLs {
    private PrintURLs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PDDocument doc = null;
        try {
            if (args.length != 1) {
                PrintURLs.usage();
            } else {
                doc = PDDocument.load(args[0]);
                List allPages = doc.getDocumentCatalog().getAllPages();
                for (int i = 0; i < allPages.size(); ++i) {
                    PDAnnotationLink link;
                    PDAnnotation annot;
                    int j;
                    PDFTextStripperByArea stripper = new PDFTextStripperByArea();
                    PDPage page = (PDPage)allPages.get(i);
                    List annotations = page.getAnnotations();
                    for (j = 0; j < annotations.size(); ++j) {
                        annot = (PDAnnotation)annotations.get(j);
                        if (!(annot instanceof PDAnnotationLink)) continue;
                        link = (PDAnnotationLink)annot;
                        PDRectangle rect = link.getRectangle();
                        float x = rect.getLowerLeftX();
                        float y = rect.getUpperRightY();
                        float width = rect.getWidth();
                        float height = rect.getHeight();
                        int rotation = page.findRotation();
                        if (rotation == 0) {
                            PDRectangle pageSize = page.findMediaBox();
                            y = pageSize.getHeight() - y;
                        } else if (rotation == 90) {
                            // empty if block
                        }
                        Rectangle2D.Float awtRect = new Rectangle2D.Float(x, y, width, height);
                        stripper.addRegion("" + j, awtRect);
                    }
                    stripper.extractRegions(page);
                    for (j = 0; j < annotations.size(); ++j) {
                        annot = (PDAnnotation)annotations.get(j);
                        if (!(annot instanceof PDAnnotationLink)) continue;
                        link = (PDAnnotationLink)annot;
                        PDAction action = link.getAction();
                        String urlText = stripper.getTextForRegion("" + j);
                        if (!(action instanceof PDActionURI)) continue;
                        PDActionURI uri = (PDActionURI)action;
                        System.out.println("Page " + (i + 1) + ":'" + urlText + "'=" + uri.getURI());
                    }
                }
            }
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: " + PrintURLs.class.getName() + " <input-file>");
    }
}

