#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# This file is part of the Wapiti project (https://wapiti.sourceforge.io)
# Copyright (C) 2013-2021 Nicolas Surribas
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
from wapitiCore.language.language import _

CRITICAL_LEVEL = "4"
HIGH_LEVEL = "3"
MEDIUM_LEVEL = "2"
LOW_LEVEL = "1"
INFO_LEVEL = "0"


class Messages:
    MSG_EVIL_URL = _("  Evil url: {0}")
    MSG_PARAM_INJECT = _("{0} in {1} via injection in the parameter {2}")
    MSG_FROM = _("  coming from {0}")
    MSG_QS_INJECT = _("{0} in {1} via injection in the query string")
    MSG_PATH_INJECT = _("{0} in {1} via injection in the resource path")
    MSG_EVIL_PARAM = _("Involved parameter: {0}")
    MSG_EVIL_REQUEST = _("Evil request:")

    ERROR_500 = _("Internal Server Error")
    RES_CONSUMPTION = _("Resource consumption")

    MSG_500 = _("Received a HTTP 500 error in {0}")
    MSG_TIMEOUT = _("Timeout occurred in {0}")

    MSG_QS_TIMEOUT = _("The request timed out while attempting to inject a payload in the query string")
    MSG_PATH_TIMEOUT = _("The request timed out while attempting to inject a payload in the resource path")
    MSG_PARAM_TIMEOUT = _("The request timed out while attempting to inject a payload in the parameter {0}")

    MSG_QS_500 = _("The server responded with a 500 HTTP error code "
                   "while attempting to inject a payload in the query string")
    MSG_PATH_500 = _("The server responded with a 500 HTTP error code "
                     "while attempting to inject a payload in the resource path")
    MSG_PARAM_500 = _("The server responded with a 500 HTTP error code "
                      "while attempting to inject a payload in the parameter {0}")
