/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.protocol.HttpContext;

public class VegaResponseProcessCookies
implements HttpResponseInterceptor {
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        CookieSpec cookieSpec = (CookieSpec)httpContext.getAttribute("http.cookie-spec");
        if (cookieSpec == null) {
            return;
        }
        CookieStore cookieStore = (CookieStore)httpContext.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            return;
        }
        CookieOrigin cookieOrigin = (CookieOrigin)httpContext.getAttribute("http.cookie-origin");
        if (cookieOrigin == null) {
            return;
        }
        HeaderIterator headerIterator = httpResponse.headerIterator("Set-Cookie");
        this.processCookies(headerIterator, cookieSpec, cookieOrigin, cookieStore);
        if (cookieSpec.getVersion() > 0) {
            headerIterator = httpResponse.headerIterator("Set-Cookie2");
            this.processCookies(headerIterator, cookieSpec, cookieOrigin, cookieStore);
        }
    }

    private void processCookies(HeaderIterator headerIterator, CookieSpec cookieSpec, CookieOrigin cookieOrigin, CookieStore cookieStore) {
        while (headerIterator.hasNext()) {
            Header header = headerIterator.nextHeader();
            try {
                List list = cookieSpec.parse(header, cookieOrigin);
                for (Cookie cookie : list) {
                    cookieStore.addCookie(cookie);
                }
            }
            catch (MalformedCookieException malformedCookieException) {}
        }
    }
}

