/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.scope;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.events.CancellableObjectEventArgs;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.query.Predicate;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.scope.ActiveScopeChangedEvent;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.model.scope.ITargetScopeManager;
import com.subgraph.vega.internal.model.scope.TargetScope;
import com.subgraph.vega.internal.model.scope.TargetScopeId;
import java.net.URI;
import java.util.Collection;

public class TargetScopeManager
implements ITargetScopeManager {
    private final ObjectContainer database;
    private final TargetScopeId scopeId;
    private final EventListenerManager scopeChangeListeners;
    private ITargetScope activeScope;
    private ITargetScope defaultScope;

    public TargetScopeManager(ObjectContainer objectContainer) {
        this.database = objectContainer;
        this.scopeId = this.getTargetScopeId(objectContainer);
        this.scopeChangeListeners = new EventListenerManager();
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer((ObjectContainer)objectContainer);
        eventRegistry.activating().addListener((EventListener4)new EventListener4<CancellableObjectEventArgs>(){

            public void onEvent(Event4<CancellableObjectEventArgs> event4, CancellableObjectEventArgs cancellableObjectEventArgs) {
                Object object = cancellableObjectEventArgs.object();
                if (object instanceof TargetScope) {
                    ((TargetScope)object).setEventListenerManager(TargetScopeManager.this.scopeChangeListeners);
                }
            }
        });
        this.defaultScope = this.findDefaultScope();
        this.activeScope = this.findActiveScope();
    }

    private TargetScopeId getTargetScopeId(ObjectContainer objectContainer) {
        ObjectSet objectSet = objectContainer.query(TargetScopeId.class);
        if (objectSet.size() == 0) {
            TargetScopeId targetScopeId = new TargetScopeId();
            objectContainer.store((Object)targetScopeId);
            return targetScopeId;
        }
        if (objectSet.size() == 1) {
            return (TargetScopeId)objectSet.get(0);
        }
        throw new IllegalStateException("Database corrupted, found multiple TargetScopeId instances");
    }

    public ITargetScope createNewScope() {
        return this.createNewScope("New Scope");
    }

    public ITargetScope createDuplicatedScope(ITargetScope iTargetScope) {
        ITargetScope iTargetScope2 = this.createNewScope(iTargetScope.getName());
        for (Object object : iTargetScope.getScopeURIs()) {
            iTargetScope2.addScopeURI((URI)object);
        }
        for (Object object : iTargetScope.getExclusionURIs()) {
            iTargetScope2.addExclusionURI((URI)object);
        }
        for (Object object : iTargetScope.getExclusionPatterns()) {
            iTargetScope2.addExclusionPattern((String)object);
        }
        return iTargetScope2;
    }

    private ITargetScope createNewScope(String string) {
        long l = this.scopeId.allocateId();
        TargetScope targetScope = new TargetScope(l, false, this.scopeChangeListeners);
        targetScope.setName(string);
        return targetScope;
    }

    private ITargetScope createDefaultScope() {
        long l = this.scopeId.allocateId();
        TargetScope targetScope = new TargetScope(l, true, this.scopeChangeListeners);
        targetScope.setIsActiveScope(true);
        targetScope.setName("Default Scope");
        this.database.store((Object)targetScope);
        return targetScope;
    }

    public void saveScope(ITargetScope iTargetScope) {
        this.database.store((Object)iTargetScope);
    }

    public boolean removeScope(ITargetScope iTargetScope) {
        if (iTargetScope == this.defaultScope) {
            return false;
        }
        if (iTargetScope == this.activeScope) {
            this.setActiveScope(this.defaultScope);
        }
        this.database.delete((Object)iTargetScope);
        return true;
    }

    public Collection<ITargetScope> getAllScopes() {
        return this.database.query(ITargetScope.class);
    }

    public ITargetScope getActiveScope() {
        return this.activeScope;
    }

    public ITargetScope getDefaultScope() {
        return this.defaultScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveScope(ITargetScope iTargetScope) {
        if (iTargetScope == this.activeScope || !this.database.ext().isStored((Object)iTargetScope)) {
            return;
        }
        TargetScopeManager targetScopeManager = this;
        synchronized (targetScopeManager) {
            ((TargetScope)this.activeScope).setIsActiveScope(false);
            ((TargetScope)iTargetScope).setIsActiveScope(true);
            this.activeScope = iTargetScope;
            this.scopeChangeListeners.fireEvent((IEvent)new ActiveScopeChangedEvent(this.activeScope));
        }
    }

    public void setScopeDetached(ITargetScope iTargetScope) {
        if (iTargetScope.isActiveScope()) {
            this.setActiveScope(this.defaultScope);
        }
        ((TargetScope)iTargetScope).setDetached(true);
    }

    public void setScopeAttached(ITargetScope iTargetScope) {
        ((TargetScope)iTargetScope).setDetached(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITargetScope addActiveScopeChangeListener(IEventHandler iEventHandler) {
        TargetScopeManager targetScopeManager = this;
        synchronized (targetScopeManager) {
            this.scopeChangeListeners.addListener(iEventHandler);
            return this.activeScope;
        }
    }

    public void removeActiveScopeChangeListener(IEventHandler iEventHandler) {
        this.scopeChangeListeners.removeListener(iEventHandler);
    }

    private ITargetScope findDefaultScope() {
        ObjectSet objectSet = this.database.query((Predicate)new Predicate<ITargetScope>(){
            private static final long serialVersionUID = 1L;

            public boolean match(ITargetScope iTargetScope) {
                return iTargetScope.isDefaultScope();
            }
        });
        if (objectSet.size() == 0) {
            return this.createDefaultScope();
        }
        return (ITargetScope)objectSet.get(0);
    }

    private ITargetScope findActiveScope() {
        ObjectSet objectSet = this.database.query((Predicate)new Predicate<ITargetScope>(){
            private static final long serialVersionUID = 1L;

            public boolean match(ITargetScope iTargetScope) {
                return iTargetScope.isActiveScope();
            }
        });
        if (objectSet.size() == 0) {
            ITargetScope iTargetScope = this.findDefaultScope();
            ((TargetScope)iTargetScope).setIsActiveScope(true);
            return iTargetScope;
        }
        return (ITargetScope)objectSet.get(0);
    }
}

