/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.macros;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.macros.IHttpMacro;
import com.subgraph.vega.api.model.macros.IHttpMacroModel;
import com.subgraph.vega.api.model.macros.NewMacroEvent;
import com.subgraph.vega.internal.model.macros.HttpMacro;
import java.util.Collection;

public class HttpMacroModel
implements IHttpMacroModel {
    private ObjectContainer database;
    private final EventListenerManager changeEventManager;

    public HttpMacroModel(ObjectContainer objectContainer) {
        this.database = objectContainer;
        this.changeEventManager = new EventListenerManager();
    }

    public Collection<IHttpMacro> getAllMacros() {
        return this.database.query(IHttpMacro.class);
    }

    public IHttpMacro createMacro() {
        return new HttpMacro();
    }

    public void store(IHttpMacro iHttpMacro) {
        this.database.store((Object)iHttpMacro);
        this.changeEventManager.fireEvent((IEvent)new NewMacroEvent(iHttpMacro));
    }

    public boolean isMacroStored(IHttpMacro iHttpMacro) {
        return this.database.ext().isStored((Object)iHttpMacro);
    }

    public IHttpMacro getMacroByName(final String string) {
        ObjectSet objectSet = this.database.query((Predicate)new Predicate<IHttpMacro>(){
            private static final long serialVersionUID = 1L;

            public boolean match(IHttpMacro iHttpMacro) {
                return string.equals(iHttpMacro.getName());
            }
        });
        if (objectSet.size() == 0) {
            return null;
        }
        return (IHttpMacro)objectSet.get(0);
    }

    public void addChangeListener(IEventHandler iEventHandler) {
        this.changeEventManager.addListener(iEventHandler);
    }

    public void removeChangeListener(IEventHandler iEventHandler) {
        this.changeEventManager.removeListener(iEventHandler);
    }
}

