/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.alerts;

import com.db4o.ObjectContainer;
import com.db4o.query.Predicate;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.alerts.NewScanAlertEvent;
import com.subgraph.vega.internal.model.alerts.ScanAlert;
import com.subgraph.vega.internal.model.alerts.ScanAlertFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class ScanInstanceAlerts {
    private static final Logger logger = Logger.getLogger("alerts");
    private final ObjectContainer database;
    private final IScanInstance scanInstance;
    private final EventListenerManager eventManager;
    private final ScanAlertFactory alertFactory;

    ScanInstanceAlerts(ObjectContainer objectContainer, IScanInstance iScanInstance, EventListenerManager eventListenerManager, ScanAlertFactory scanAlertFactory) {
        this.database = objectContainer;
        this.scanInstance = iScanInstance;
        this.eventManager = eventListenerManager;
        this.alertFactory = scanAlertFactory;
    }

    public IScanAlert createAlert(String string, String string2, long l) {
        return this.alertFactory.createAlert(string2, string, this.scanInstance, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlert(IScanAlert iScanAlert) {
        ScanInstanceAlerts scanInstanceAlerts = this;
        synchronized (scanInstanceAlerts) {
            if (this.rejectDuplicateAlert(iScanAlert)) {
                return;
            }
            this.database.store((Object)iScanAlert);
        }
        this.eventManager.fireEvent((IEvent)new NewScanAlertEvent(iScanAlert));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlerts(Collection<IScanAlert> collection) {
        ScanInstanceAlerts scanInstanceAlerts = this;
        synchronized (scanInstanceAlerts) {
            for (IScanAlert iScanAlert : collection) {
                this.database.delete((Object)iScanAlert);
            }
        }
    }

    private boolean rejectDuplicateAlert(IScanAlert iScanAlert) {
        if (iScanAlert.getResource() == null) {
            return false;
        }
        for (ScanAlert scanAlert : this.getAlertListForResource(iScanAlert.getResource())) {
            if (!scanAlert.equals(iScanAlert)) continue;
            return true;
        }
        if (iScanAlert.getKey() == null) {
            return false;
        }
        return this.hasAlertKey(iScanAlert.getKey());
    }

    private List<ScanAlert> getAlertListForResource(final String string) {
        return this.database.query((Predicate)new Predicate<ScanAlert>(){
            private static final long serialVersionUID = 1L;

            public boolean match(ScanAlert scanAlert) {
                return string.equals(scanAlert.getResource()) && scanAlert.getScanId() == ScanInstanceAlerts.this.scanInstance.getScanId();
            }
        });
    }

    public boolean hasAlertKey(String string) {
        return this.getAlertByKey(string) != null;
    }

    public IScanAlert getAlertByKey(String string) {
        if (string == null) {
            return null;
        }
        List<ScanAlert> list = this.getAlertListForKey(string);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            logger.warning("Multiple alert model entries for key: " + string);
        }
        return list.get(0);
    }

    private List<ScanAlert> getAlertListForKey(final String string) {
        return this.database.query((Predicate)new Predicate<ScanAlert>(){
            private static final long serialVersionUID = 1L;

            public boolean match(ScanAlert scanAlert) {
                return string.equals(scanAlert.getKey()) && scanAlert.getScanId() == ScanInstanceAlerts.this.scanInstance.getScanId();
            }
        });
    }

    public List<IScanAlert> getAllAlerts() {
        return this.database.query((Predicate)new Predicate<IScanAlert>(){
            private static final long serialVersionUID = 1L;

            public boolean match(IScanAlert iScanAlert) {
                return iScanAlert.getScanId() == ScanInstanceAlerts.this.scanInstance.getScanId();
            }
        });
    }

    public void removeAllAlerts() {
        ArrayList<IScanAlert> arrayList = new ArrayList<IScanAlert>(this.getAllAlerts());
        this.removeAlerts(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanEventListenerAndPopulate(IEventHandler iEventHandler) {
        List<IScanAlert> list = null;
        ScanInstanceAlerts scanInstanceAlerts2 = this;
        synchronized (scanInstanceAlerts2) {
            list = this.getAllAlerts();
            this.eventManager.addListener(iEventHandler);
        }
        for (IScanAlert iScanAlert : list) {
            iEventHandler.handleEvent((IEvent)new NewScanAlertEvent(iScanAlert));
        }
    }
}

