/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.wizards;

import com.subgraph.vega.api.model.identity.IIdentity;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class NewScanAuthPage
extends WizardPage {
    private Table cookiesTable;
    private static final Object emptyIdentity = new Object();
    private final List<Object> identities;
    private ComboViewer scanIdentityViewer;

    protected NewScanAuthPage(Collection<IIdentity> collection) {
        super("Authentication");
        this.setTitle("Authentication Options");
        this.setDescription("Configure cookies and authentication identity to use during scan");
        this.identities = new ArrayList<Object>(collection.size() + 1);
        this.identities.add(emptyIdentity);
        this.identities.addAll(collection);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.createIdentityPart(composite2);
        this.createCookiesPart(composite2);
        this.setControl((Control)composite2);
    }

    private void createIdentityPart(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Identity to scan site as:");
        this.scanIdentityViewer = new ComboViewer(composite, 8);
        this.scanIdentityViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.scanIdentityViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.scanIdentityViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                if (object != emptyIdentity) {
                    return ((IIdentity)object).getName();
                }
                return "";
            }
        });
        Object[] objectArray = this.identities.toArray(new Object[0]);
        this.scanIdentityViewer.setInput((Object)objectArray);
        this.scanIdentityViewer.setSelection((ISelection)new StructuredSelection(objectArray[0]));
    }

    private void createCookiesPart(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Set-Cookie or Set-Cookie2 value:");
        final Text text = new Text(composite, 2052);
        text.setLayoutData((Object)new GridData(768));
        final Button button = new Button(composite, 8);
        button.setText("Add cookie");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String string;
                if (event.widget == button && (string = text.getText()) != null) {
                    TableItem tableItem;
                    TableItem[] tableItemArray;
                    TableItem[] tableItemArray2 = tableItemArray = NewScanAuthPage.this.cookiesTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        tableItem = tableItemArray2[n2];
                        if (text.getText().equals(tableItem.getText())) {
                            return;
                        }
                        ++n2;
                    }
                    try {
                        HttpCookie.parse(text.getText());
                    }
                    catch (Exception exception) {
                        NewScanAuthPage.this.setErrorMessage("Cookie error: " + exception.getMessage());
                        return;
                    }
                    tableItem = new TableItem(NewScanAuthPage.this.cookiesTable, 0);
                    tableItem.setText(text.getText());
                }
            }
        });
        this.cookiesTable = new Table(composite, 2050);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 140;
        gridData.heightHint = 60;
        this.cookiesTable.setLayoutData((Object)gridData);
        Button button2 = new Button(composite, 8);
        button2.setText("Remove selected cookie(s)");
        button2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewScanAuthPage.this.cookiesTable.remove(NewScanAuthPage.this.cookiesTable.getSelectionIndices());
            }
        });
    }

    public List<String> getCookieStringList() {
        return this.getTableItemsAsString(this.cookiesTable);
    }

    private List<String> getTableItemsAsString(Table table) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            arrayList.add(tableItem.getText());
            ++n2;
        }
        return arrayList;
    }

    public IIdentity getScanIdentity() {
        Object object = ((IStructuredSelection)this.scanIdentityViewer.getSelection()).getFirstElement();
        if (object != emptyIdentity) {
            return (IIdentity)object;
        }
        return null;
    }
}

