/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.dashboard;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class CrawlerProgressPane
extends Composite {
    private final StackLayout stack = new StackLayout();
    private final Composite progressBarPage;
    private final Composite progressLabelPage;
    private final Label progressLabel;
    private final ProgressBar progressBar;

    public CrawlerProgressPane(Composite composite, Color color) {
        super(composite, 0);
        this.setLayout((Layout)this.stack);
        this.setBackground(color);
        this.progressBarPage = this.createPage(this, color);
        this.progressLabelPage = this.createPage(this, color);
        this.progressLabel = this.createProgressLabel(this.progressLabelPage);
        this.progressLabel.setBackground(color);
        this.progressBar = this.createProgressBar(this.progressBarPage);
        this.progressBar.setBackground(color);
        this.setLabelText("Scanner idle.");
    }

    private Composite createPage(Composite composite, Color color) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setBackground(color);
        return composite2;
    }

    private Label createProgressLabel(Composite composite) {
        Label label = new Label(composite, 0x1000000);
        label.setFont(JFaceResources.getBannerFont());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 400;
        gridData.verticalIndent = 20;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private ProgressBar createProgressBar(Composite composite) {
        ProgressBar progressBar = new ProgressBar(composite, 65536);
        progressBar.setMinimum(0);
        progressBar.setMaximum(100);
        GridData gridData = new GridData(4, 1024, true, true);
        gridData.widthHint = 400;
        progressBar.setLayoutData((Object)gridData);
        return progressBar;
    }

    void setLabelText(String string) {
        if (this.progressLabel.isDisposed()) {
            return;
        }
        this.progressLabel.setText(string);
        if (this.stack.topControl != this.progressLabelPage) {
            this.stack.topControl = this.progressLabelPage;
            this.layout();
        }
    }

    void setProgressBarValue(int n) {
        if (this.progressBar.isDisposed()) {
            return;
        }
        this.progressBar.setSelection(n);
        if (this.stack.topControl != this.progressBarPage) {
            this.stack.topControl = this.progressBarPage;
            this.layout();
        }
    }
}

