/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts.tree;

import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.ui.scanner.alerts.IAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AbstractAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertTitleNode;

public class AlertSeverityNode
extends AbstractAlertTreeNode {
    private static final String ALERT_LOW = "icons/alert_low.png";
    private static final String ALERT_MEDIUM = "icons/alert_medium.png";
    private static final String ALERT_HIGH = "icons/alert_high.png";
    private static final String ALERT_INFO = "icons/alert_info.png";
    private final IScanAlert.Severity severity;

    AlertSeverityNode(AbstractAlertTreeNode abstractAlertTreeNode, IScanAlert.Severity severity) {
        super(abstractAlertTreeNode);
        this.severity = severity;
    }

    public IScanAlert.Severity getSeverity() {
        return this.severity;
    }

    @Override
    public String getKey() {
        return this.severity.toString();
    }

    public int getSeverityIndex() {
        switch (this.severity) {
            case HIGH: {
                return 5;
            }
            case MEDIUM: {
                return 4;
            }
            case LOW: {
                return 3;
            }
            case INFO: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public String getLabel() {
        switch (this.severity) {
            case HIGH: {
                return "High";
            }
            case MEDIUM: {
                return "Medium";
            }
            case LOW: {
                return "Low";
            }
            case INFO: {
                return "Info";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "";
    }

    @Override
    public String getImage() {
        switch (this.severity) {
            case HIGH: {
                return ALERT_HIGH;
            }
            case MEDIUM: {
                return ALERT_MEDIUM;
            }
            case LOW: {
                return ALERT_LOW;
            }
            case INFO: {
                return ALERT_INFO;
            }
            case UNKNOWN: {
                return null;
            }
        }
        return null;
    }

    @Override
    protected IAlertTreeNode createNodeForAlert(IScanAlert iScanAlert) {
        return new AlertTitleNode(this, iScanAlert.getTitle());
    }

    @Override
    protected String createKeyForAlert(IScanAlert iScanAlert) {
        return iScanAlert.getTitle();
    }
}

