/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application.preferences;

import com.subgraph.vega.application.Activator;
import com.subgraph.vega.application.preferences.IPreferenceConstants;
import com.subgraph.vega.ui.util.preferences.VegaPreferencePage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class ProxyPreferencePage
extends VegaPreferencePage
implements IPropertyChangeListener,
IPreferenceConstants {
    private Composite parentComposite;
    private Composite socksConfigControl;
    private BooleanFieldEditor socksEnableField;
    private StringFieldEditor socksAddressField;
    private IntegerFieldEditor socksPortField;
    private Composite httpProxyConfigControl;
    private BooleanFieldEditor httpProxyEnableField;
    private StringFieldEditor httpProxyAddressField;
    private IntegerFieldEditor httpProxyPortField;

    public ProxyPreferencePage() {
        super("External Proxy Options");
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createPage(Composite composite) {
        this.parentComposite = new SashForm(composite, 512);
        this.createSocksGroup(this.parentComposite);
        this.createHttpProxyGroup(this.parentComposite);
        this.updateEnableState();
        return this.parentComposite;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateEnableState();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("field_editor_value")) {
            if (propertyChangeEvent.getSource() == this.socksEnableField) {
                this.setSocksEnableState((Boolean)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getSource() == this.httpProxyEnableField) {
                this.setHttpProxyEnableState((Boolean)propertyChangeEvent.getNewValue());
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    private Composite createSocksGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("SOCKS proxy");
        Label label = new Label((Composite)group, 0);
        label.setText("Configure Vega to use a SOCKS proxy for all connections");
        this.socksEnableField = new BooleanFieldEditor("vega.preferences.socksEnabled", "Enable SOCKS proxy", (Composite)group);
        this.addField((FieldEditor)this.socksEnableField);
        this.socksConfigControl = new Composite((Composite)group, 0);
        this.socksConfigControl.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.socksAddressField = new StringFieldEditor("vega.preferences.socksAddress", "Proxy Address", this.socksConfigControl);
        this.socksAddressField.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.socksAddressField);
        this.socksPortField = new IntegerFieldEditor("vega.preferences.socksPort", "Proxy Port", this.socksConfigControl);
        this.socksPortField.setValidRange(1, 65535);
        this.socksPortField.setTextLimit(5);
        this.addField((FieldEditor)this.socksPortField);
        return group;
    }

    private Composite createHttpProxyGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("External HTTP proxy");
        Label label = new Label((Composite)group, 0);
        label.setText("Configure Vega to send all requests through an external HTTP proxy");
        this.httpProxyEnableField = new BooleanFieldEditor("vega.preferences.proxyEnabled", "Enable HTTP proxy", (Composite)group);
        this.addField((FieldEditor)this.httpProxyEnableField);
        this.httpProxyConfigControl = new Composite((Composite)group, 0);
        this.httpProxyConfigControl.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.httpProxyAddressField = new StringFieldEditor("vega.preferences.proxyAddress", "Proxy Address", this.httpProxyConfigControl);
        this.httpProxyAddressField.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.httpProxyAddressField);
        this.httpProxyPortField = new IntegerFieldEditor("vega.preferences.proxyPort", "Proxy Port", this.httpProxyConfigControl);
        this.httpProxyPortField.setValidRange(1, 65535);
        this.httpProxyPortField.setTextLimit(5);
        this.addField((FieldEditor)this.httpProxyPortField);
        return group;
    }

    private void updateEnableState() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.setSocksEnableState(iPreferenceStore.getBoolean("vega.preferences.socksEnabled"));
        this.setHttpProxyEnableState(iPreferenceStore.getBoolean("vega.preferences.proxyEnabled"));
    }

    private void setSocksEnableState(Boolean bl) {
        this.socksAddressField.setEnabled(bl.booleanValue(), this.socksConfigControl);
        this.socksPortField.setEnabled(bl.booleanValue(), this.socksConfigControl);
    }

    private void setHttpProxyEnableState(Boolean bl) {
        this.httpProxyAddressField.setEnabled(bl.booleanValue(), this.httpProxyConfigControl);
        this.httpProxyPortField.setEnabled(bl.booleanValue(), this.httpProxyConfigControl);
    }
}

