/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application;

import com.subgraph.vega.api.console.IConsole;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.paths.IPathFinder;
import com.subgraph.vega.application.Activator;
import com.subgraph.vega.application.ApplicationWorkbenchAdvisor;
import com.subgraph.vega.application.console.ConsoleHandler;
import com.subgraph.vega.application.logging.LogFormatter;
import com.subgraph.vega.application.logging.LogHandler;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Application
implements IApplication {
    public Object start(IApplicationContext iApplicationContext) throws Exception {
        Display display = PlatformUI.createDisplay();
        this.setupLogging();
        if (!this.lockInstance()) {
            MessageDialog.openError(null, (String)"Vega already running", (String)"An instance of the Vega application is already running.");
            return IApplication.EXIT_OK;
        }
        if (!this.setupWorkspace()) {
            return IApplication.EXIT_OK;
        }
        ConsoleHandler consoleHandler = new ConsoleHandler(display, Activator.getDefault().getConsole());
        consoleHandler.activate();
        try {
            int n = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (n == 1) {
                Integer n2 = IApplication.EXIT_RESTART;
                return n2;
            }
            Integer n3 = IApplication.EXIT_OK;
            return n3;
        }
        finally {
            display.dispose();
        }
    }

    private boolean lockInstance() {
        URL uRL = this.getLockLocationURL();
        if (uRL != null) {
            Location location;
            block6: {
                location = Platform.getInstanceLocation();
                if (!location.isSet()) {
                    location.set(uRL, false);
                }
                if (!location.isLocked()) break block6;
                return false;
            }
            try {
                location.lock();
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                MessageDialog.openWarning(null, (String)"Warning", (String)("Exception trying to lock Vega instance: " + illegalStateException.getMessage()));
            }
            catch (IOException iOException) {
                MessageDialog.openWarning(null, (String)"Warning", (String)("I/O Exception trying to lock Vega instance: " + iOException.getMessage()));
            }
        }
        return true;
    }

    private URL getLockLocationURL() {
        IPathFinder iPathFinder = Activator.getDefault().getPathFinder();
        File file = iPathFinder.getWorkspaceDirectory();
        try {
            return new URL("file:" + file.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void setupLogging() {
        Logger logger = Logger.getLogger("");
        IConsole iConsole = Activator.getDefault().getConsole();
        if (iConsole != null) {
            LogHandler logHandler = new LogHandler(iConsole);
            logHandler.setFormatter(new LogFormatter());
            logHandler.setLevel(Level.FINEST);
            Handler[] handlerArray = logger.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                logger.removeHandler(handler);
                ++n2;
            }
            logger.addHandler(logHandler);
        }
        logger.setLevel(Level.WARNING);
    }

    private boolean setupWorkspace() {
        IModel iModel = Activator.getDefault().getModel();
        if (iModel == null) {
            MessageDialog.openError(null, (String)"Initialization Error", (String)"Failed to obtain model service");
            return false;
        }
        if (!iModel.openDefaultWorkspace()) {
            MessageDialog.openError(null, (String)"Initialization Error", (String)"Could not open workspace");
            return false;
        }
        return true;
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench iWorkbench = PlatformUI.getWorkbench();
        final Display display = iWorkbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    iWorkbench.close();
                }
            }
        });
    }
}

