/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.statusview;

import com.subgraph.vega.api.http.proxy.IProxyTransaction;
import com.subgraph.vega.api.http.requests.IHttpRequestTask;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.api.model.requests.IRequestOriginProxy;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.intercept.InterceptView;
import com.subgraph.vega.ui.http.statusview.InterceptQueueTableContentProvider;
import com.subgraph.vega.ui.http.statusview.RequestStatusTableContentProvider;
import com.subgraph.vega.ui.util.dialogs.ErrorDialog;
import java.net.URI;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class StatusView
extends ViewPart {
    public static final String ID = "com.subgraph.vega.views.proxystatus";
    private SashForm parentComposite;
    private TableViewer interceptQueueTableViewer;
    private Menu interceptQueueTableMenu;
    private TableViewer requestStatusTableViewer;
    private Menu requestStatusTableMenu;

    public void createPartControl(Composite composite) {
        this.parentComposite = new SashForm(composite, 512);
        this.parentComposite.setLayout((Layout)new FillLayout());
        this.createInterceptQueueArea((Composite)this.parentComposite);
        this.createRequestStatusArea((Composite)this.parentComposite);
        this.parentComposite.setWeights(new int[]{75, 25});
        this.interceptQueueTableViewer.setInput((Object)Activator.getDefault().getProxyService().getInterceptor());
        this.requestStatusTableViewer.setInput((Object)Activator.getDefault().getProxyService());
    }

    public void setFocus() {
    }

    private Composite createInterceptQueueArea(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Interceptor Queue");
        this.createInterceptQueueTable((Composite)group).setLayoutData((Object)new GridData(1808));
        return group;
    }

    private Composite createInterceptQueueTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite2.setLayout((Layout)tableColumnLayout);
        this.interceptQueueTableViewer = new TableViewer(composite2, 68354);
        this.interceptQueueTableViewer.setContentProvider((IContentProvider)new InterceptQueueTableContentProvider());
        this.createInterceptQueueTableColumns(this.interceptQueueTableViewer, tableColumnLayout);
        Table table = this.interceptQueueTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.interceptQueueTableViewer.addSelectionChangedListener(this.createInterceptQueueTableSelectionChangedListener());
        this.interceptQueueTableViewer.addDoubleClickListener(this.createInterceptQueueTableDoubleClickListener());
        table.setMenu(this.createInterceptQueueTableMenu(table));
        return composite2;
    }

    private void createInterceptQueueTableColumns(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        String[] stringArray = new String[]{"Type", "Host", "Method", "Request", "Listener"};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(60, true, true), new ColumnPixelData(120, true, true), new ColumnPixelData(60, true, true), new ColumnWeightData(100, 100, true), new ColumnPixelData(100, true, true)};
        ColumnLabelProvider[] columnLabelProviderArray = new ColumnLabelProvider[]{new ColumnLabelProvider(){

            public String getText(Object object) {
                return !((IProxyTransaction)object).hasResponse() ? "Request" : "Response";
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return StatusView.this.uriToHostString(((IProxyTransaction)object).getRequest().getURI());
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IProxyTransaction)object).getRequest().getMethod();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return StatusView.this.uriToPathString(((IProxyTransaction)object).getRequest().getURI());
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                IRequestOrigin iRequestOrigin = ((IProxyTransaction)object).getRequestEngine().getRequestOrigin();
                if (iRequestOrigin instanceof IRequestOriginProxy) {
                    return iRequestOrigin.toString();
                }
                return null;
            }
        }};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumnLayout.setColumnData((Widget)tableColumn, columnLayoutDataArray[n]);
            tableColumn.setText(stringArray[n]);
            tableColumn.setMoveable(true);
            tableViewerColumn.setLabelProvider((CellLabelProvider)columnLabelProviderArray[n]);
            ++n;
        }
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private ISelectionChangedListener createInterceptQueueTableSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StatusView.this.interceptQueueTableMenu.setEnabled(!selectionChangedEvent.getSelection().isEmpty());
            }
        };
    }

    private IDoubleClickListener createInterceptQueueTableDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                InterceptView interceptView;
                Object object = ((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement();
                try {
                    interceptView = (InterceptView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.subgraph.vega.views.intercept");
                }
                catch (PartInitException partInitException) {
                    ErrorDialog.displayExceptionError((Shell)StatusView.this.parentComposite.getShell(), (Exception)((Object)partInitException));
                    return;
                }
                interceptView.openTransaction((IProxyTransaction)object);
            }
        };
    }

    private Menu createInterceptQueueTableMenu(Table table) {
        this.interceptQueueTableMenu = new Menu((Control)table);
        this.interceptQueueTableMenu.setEnabled(false);
        MenuItem menuItem = new MenuItem(this.interceptQueueTableMenu, 64);
        menuItem.setText("Forward Transaction");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StatusView.this.forwardInterceptQueueSelection();
            }
        });
        MenuItem menuItem2 = new MenuItem(this.interceptQueueTableMenu, 64);
        menuItem2.setText("Drop Transaction");
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StatusView.this.dropInterceptQueueSelection();
            }
        });
        return this.interceptQueueTableMenu;
    }

    private void forwardInterceptQueueSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.interceptQueueTableViewer.getSelection();
        for (IProxyTransaction iProxyTransaction : iStructuredSelection) {
            iProxyTransaction.doForward();
        }
    }

    private void dropInterceptQueueSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.interceptQueueTableViewer.getSelection();
        for (IProxyTransaction iProxyTransaction : iStructuredSelection) {
            iProxyTransaction.doDrop();
        }
    }

    private Composite createRequestStatusArea(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Request Status");
        this.createRequestStatusTable((Composite)group).setLayoutData((Object)new GridData(1808));
        return group;
    }

    private Composite createRequestStatusTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite2.setLayout((Layout)tableColumnLayout);
        this.requestStatusTableViewer = new TableViewer(composite2, 68354);
        this.requestStatusTableViewer.setContentProvider((IContentProvider)new RequestStatusTableContentProvider());
        this.createRequestStatusTableColumns(this.requestStatusTableViewer, tableColumnLayout);
        Table table = this.requestStatusTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.requestStatusTableViewer.addSelectionChangedListener(this.createRequestStatusTableSelectionChangedListener());
        table.setMenu(this.createRequestStatusTableMenu(table));
        return composite2;
    }

    private String uriToHostString(URI uRI) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(uRI.getScheme());
        stringBuilder.append("://");
        stringBuilder.append(uRI.getHost());
        if (uRI.getPort() != -1) {
            stringBuilder.append(':');
            stringBuilder.append(Integer.toString(uRI.getPort()));
        }
        return stringBuilder.toString();
    }

    private String uriToPathString(URI uRI) {
        if (uRI.getRawQuery() != null) {
            return String.valueOf(uRI.getRawPath()) + "?" + uRI.getRawQuery();
        }
        return uRI.getRawPath();
    }

    private void createRequestStatusTableColumns(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        String[] stringArray = new String[]{"Status", "Host", "Method", "Request", "Listener"};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(45, true, true), new ColumnPixelData(120, true, true), new ColumnPixelData(60, true, true), new ColumnWeightData(100, 100, true), new ColumnPixelData(100, true, true)};
        ColumnLabelProvider[] columnLabelProviderArray = new ColumnLabelProvider[]{new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpRequestTask)object).getTimeCompleted() == null ? "in progress" : "complete";
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return StatusView.this.uriToHostString(((IHttpRequestTask)object).getRequest().getURI());
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpRequestTask)object).getRequest().getMethod();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return StatusView.this.uriToPathString(((IHttpRequestTask)object).getRequest().getURI());
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                IRequestOrigin iRequestOrigin = ((IHttpRequestTask)object).getRequestEngine().getRequestOrigin();
                if (iRequestOrigin instanceof IRequestOriginProxy) {
                    return iRequestOrigin.toString();
                }
                return null;
            }
        }};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumnLayout.setColumnData((Widget)tableColumn, columnLayoutDataArray[n]);
            tableColumn.setText(stringArray[n]);
            tableColumn.setMoveable(true);
            tableViewerColumn.setLabelProvider((CellLabelProvider)columnLabelProviderArray[n]);
            ++n;
        }
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private ISelectionChangedListener createRequestStatusTableSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StatusView.this.requestStatusTableMenu.setEnabled(!selectionChangedEvent.getSelection().isEmpty());
            }
        };
    }

    private Menu createRequestStatusTableMenu(Table table) {
        this.requestStatusTableMenu = new Menu((Control)table);
        this.requestStatusTableMenu.setEnabled(false);
        MenuItem menuItem = new MenuItem(this.requestStatusTableMenu, 64);
        menuItem.setText("Abort Request");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StatusView.this.abortRequestStatusSelection();
            }
        });
        return this.requestStatusTableMenu;
    }

    private void abortRequestStatusSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.requestStatusTableViewer.getSelection();
        for (IHttpRequestTask iHttpRequestTask : iStructuredSelection) {
            iHttpRequestTask.abort();
        }
    }
}

