/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.conditions;

import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MatchActionArgumentPanel
extends Composite {
    private final StackLayout stackLayout = new StackLayout();
    private final Composite matchStringInputPanel;
    private final Text matchStringText;
    private final Composite regexInputPanel;
    private final Text regexText;
    private final Composite integerInputPanel;
    private final Text integerText;
    private final Composite rangeInputPanel;
    private final Text rangeLowText;
    private final Text rangeHighText;

    public MatchActionArgumentPanel(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)this.stackLayout);
        this.regexInputPanel = this.createStackedPanel(1);
        this.regexText = this.createTextField(this.regexInputPanel, "regular expression", true);
        this.matchStringInputPanel = this.createStackedPanel(1);
        this.matchStringText = this.createTextField(this.matchStringInputPanel, "matching string", true);
        this.integerInputPanel = this.createStackedPanel(1);
        this.integerText = this.createTextField(this.integerInputPanel, "integer value", true);
        this.rangeInputPanel = this.createStackedPanel(3);
        this.rangeLowText = this.createTextField(this.rangeInputPanel, "from", false);
        this.createRangeSeperator(this.rangeInputPanel);
        this.rangeHighText = this.createTextField(this.rangeInputPanel, "to", false);
    }

    public void displayPanelForMatchAction(IHttpConditionMatchAction iHttpConditionMatchAction) {
        switch (iHttpConditionMatchAction.getArgumentType()) {
            case ARGUMENT_REGEX: {
                this.displayRegexPanel();
                break;
            }
            case ARGUMENT_STRING: {
                this.displayStringPanel();
                break;
            }
            case ARGUMENT_INTEGER: {
                this.displayIntegerPanel();
                break;
            }
            case ARGUMENT_RANGE: {
                this.displayRangePanel();
            }
        }
    }

    public void displayRegexPanel() {
        this.regexText.setText("");
        this.stackLayout.topControl = this.regexInputPanel;
        this.layout();
    }

    public String getRegexText() {
        return this.regexText.getText();
    }

    public void displayStringPanel() {
        this.matchStringText.setText("");
        this.stackLayout.topControl = this.matchStringInputPanel;
        this.layout();
    }

    public String getStringText() {
        return this.matchStringText.getText();
    }

    public void displayIntegerPanel() {
        this.integerText.setText("");
        this.stackLayout.topControl = this.integerInputPanel;
        this.layout();
    }

    public String getIntegerText() {
        return this.integerText.getText();
    }

    public void displayRangePanel() {
        this.rangeLowText.setText("");
        this.rangeHighText.setText("");
        this.stackLayout.topControl = this.rangeInputPanel;
        this.layout();
    }

    public String getRangeLowText() {
        return this.rangeLowText.getText();
    }

    public String getRangeHighText() {
        return this.rangeHighText.getText();
    }

    private Composite createStackedPanel(int n) {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(n, false));
        return composite;
    }

    private Text createTextField(Composite composite, String string, boolean bl) {
        Text text = new Text(composite, 2052);
        text.setMessage(string);
        text.setLayoutData((Object)new GridData(4, 0x1000000, bl, false));
        return text;
    }

    private Label createRangeSeperator(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(" - ");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        return label;
    }
}

