/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.ui.http.requestlogviewer;

import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.model.requests.IRequestLog;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;

public class FilterTask {
    private static final int UPDATE_VIEWER_INTERVAL = 500;
    private static final int INITIAL_CHUNK_SIZE = 200;
    private static final int LOAD_CHUNK_SIZE = 1000;
    private final IRequestLog requestLog;
    private final IHttpConditionSet filter;
    private final TableViewer viewer;
    private final Display display;
    private final List<IRequestLogRecord> records;
    private final List<IRequestLogRecord> addedRecords;
    private final Thread thread;
    private final Object lock = new Object();
    private volatile boolean isStarted;
    private volatile boolean isCancelled;
    private boolean isFinished;
    private volatile long nextRequestId;
    private int lastSize;

    FilterTask(TableViewer tableViewer, IRequestLog iRequestLog, IHttpConditionSet iHttpConditionSet) {
        this.viewer = tableViewer;
        this.display = tableViewer.getControl().getDisplay();
        this.requestLog = iRequestLog;
        this.filter = iHttpConditionSet;
        this.records = new ArrayList<IRequestLogRecord>();
        this.addedRecords = new ArrayList<IRequestLogRecord>();
        this.thread = new Thread(this.createRunnable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRequestLogRecord getRecordForIndex(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n < this.records.size()) {
                return this.records.get(n);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNewRecord(IRequestLogRecord iRequestLogRecord) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isFinished) {
                this.records.add(iRequestLogRecord);
            } else if (iRequestLogRecord.getRequestId() >= this.nextRequestId) {
                this.addedRecords.add(iRequestLogRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyFilter() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStarted) {
                return;
            }
            this.nextRequestId = this.requestLog.getNextRequestId();
            this.isStarted = true;
            this.thread.start();
        }
    }

    void cancel() {
        this.isCancelled = true;
    }

    private void loadRecords() {
        Iterator iterator = this.requestLog.getRecordIteratorByConditionSet(this.filter);
        if (this.loadChunk(iterator, 200)) {
            return;
        }
        if (this.records.size() > 0) {
            this.selectViewerItem(this.records.get(0));
        }
        while (iterator.hasNext()) {
            if (!this.loadChunk(iterator, 1000)) continue;
            return;
        }
        this.performFinalMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadChunk(Iterator<IRequestLogRecord> iterator, int n) {
        int n2;
        Object object = this.lock;
        synchronized (object) {
            int n3 = 0;
            while (true) {
                if (n3 >= n || !iterator.hasNext()) {
                    n2 = this.records.size();
                    break;
                }
                if (this.isCancelled) {
                    return true;
                }
                IRequestLogRecord iRequestLogRecord = iterator.next();
                if (iRequestLogRecord.getRequestId() < this.nextRequestId) {
                    this.records.add(iRequestLogRecord);
                }
                ++n3;
            }
        }
        this.applyRecordCountToViewer(n2);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFinalMerge() {
        int n;
        Object object = this.lock;
        synchronized (object) {
            this.records.addAll(this.addedRecords);
            this.addedRecords.clear();
            n = this.records.size();
            this.isFinished = true;
            this.lock.notifyAll();
        }
        this.applyRecordCountToViewer(n);
    }

    private void selectViewerItem(final IRequestLogRecord iRequestLogRecord) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FilterTask.this.viewer.getControl().isDisposed() && !FilterTask.this.isCancelled) {
                    FilterTask.this.viewer.setSelection((ISelection)new StructuredSelection((Object)iRequestLogRecord));
                }
            }
        });
    }

    private void applyRecordCountToViewer(final int n) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FilterTask.this.viewer.getControl().isDisposed() && !FilterTask.this.isCancelled) {
                    FilterTask.this.viewer.setItemCount(n);
                    FilterTask.this.viewer.refresh(false);
                }
            }
        });
    }

    private Runnable createRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                FilterTask.this.loadRecords();
                FilterTask.this.runUpdateViewerLoop();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdateViewerLoop() {
        while (!this.isCancelled) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (this.isCancelled) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.records.size() != this.lastSize) {
                    this.lastSize = this.records.size();
                    this.applyRecordCountToViewer(this.lastSize);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRowForRecord(IRequestLogRecord iRequestLogRecord) {
        Object object = this.lock;
        synchronized (object) {
            while (!this.isFinished) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    return -1;
                }
            }
            return this.records.indexOf(iRequestLogRecord);
        }
    }
}

