/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.hexeditor;

import com.subgraph.vega.ui.hexeditor.HexEditFonts;
import com.subgraph.vega.ui.hexeditor.HexEditModelItem;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class HexEditLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableFontProvider {
    private final HexEditFonts fonts;

    HexEditLabelProvider(HexEditFonts hexEditFonts) {
        this.fonts = hexEditFonts;
    }

    public Image getColumnImage(Object object, int n) {
        return null;
    }

    public String getColumnText(Object object, int n) {
        if (!(object instanceof HexEditModelItem)) {
            return null;
        }
        HexEditModelItem hexEditModelItem = (HexEditModelItem)object;
        if (n == 0) {
            return String.format("%04X:", hexEditModelItem.getOffset());
        }
        if (n > 0 && n <= hexEditModelItem.getRowLength()) {
            int n2 = hexEditModelItem.getByteAt(n - 1);
            if (n2 == -1) {
                return "";
            }
            return String.format("%02X", n2);
        }
        if (n == hexEditModelItem.getRowLength() + 1) {
            return this.renderAscii(hexEditModelItem);
        }
        return "???";
    }

    private String renderAscii(HexEditModelItem hexEditModelItem) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = hexEditModelItem.getRowByteCount();
        byte[] byArray = new byte[n];
        hexEditModelItem.getData(byArray);
        int n2 = 0;
        while (n2 < hexEditModelItem.getRowLength()) {
            if (n2 >= byArray.length) {
                stringBuilder.append(" ");
            } else {
                stringBuilder.append(this.renderByte(byArray[n2]));
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private String renderByte(byte by) {
        if (this.isPrintable(by)) {
            return Character.toString((char)by);
        }
        return ".";
    }

    private boolean isPrintable(byte by) {
        return by >= 32 && by <= 126;
    }

    public Font getFont(Object object, int n) {
        if (!(object instanceof HexEditModelItem)) {
            return null;
        }
        HexEditModelItem hexEditModelItem = (HexEditModelItem)object;
        if (n <= hexEditModelItem.getRowLength()) {
            return this.fonts.getElementFont();
        }
        return this.fonts.getAsciiFont();
    }
}

