/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.tagsl.taggablepopup;

import com.subgraph.vega.api.model.tags.ITag;
import com.subgraph.vega.api.model.tags.ITaggable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TaggablePopupDialog
extends PopupDialog {
    private Composite parentComposite;
    private ITaggable taggable;
    private Point origin;
    private List<Label> tagLabelList;

    public TaggablePopupDialog(Shell shell, ITaggable iTaggable, Point point) {
        super(shell, 540676, false, false, false, false, false, null, null);
        this.taggable = iTaggable;
        this.origin = point;
    }

    protected Control createDialogArea(Composite composite) {
        this.parentComposite = new Composite(composite, 0);
        this.parentComposite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(this.parentComposite, 0);
        label.setText("Tags:");
        FontData[] fontDataArray = label.getFont().getFontData();
        fontDataArray[0].setStyle(1);
        final Font font = new Font((Device)this.parentComposite.getDisplay(), fontDataArray[0]);
        label.setFont(font);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                font.dispose();
            }
        });
        Collection collection = this.taggable.getAllTags();
        this.tagLabelList = new ArrayList<Label>(collection.size());
        for (ITag iTag : collection) {
            this.tagLabelList.add(this.createTagLabel(this.parentComposite, iTag));
        }
        return this.parentComposite;
    }

    protected boolean hasInfoArea() {
        return false;
    }

    protected boolean hasTitleArea() {
        return false;
    }

    protected Point getInitialLocation(Point point) {
        int n = this.origin.x - point.x;
        int n2 = n > 0 ? n : this.origin.x;
        return new Point(n2, this.origin.y);
    }

    protected Color getBackground() {
        return this.parentComposite.getDisplay().getSystemColor(25);
    }

    protected List getForegroundColorExclusions() {
        List list = super.getForegroundColorExclusions();
        ArrayList<Label> arrayList = new ArrayList<Label>(list.size() + this.tagLabelList.size());
        arrayList.addAll(list);
        arrayList.addAll(this.tagLabelList);
        return arrayList;
    }

    private Label createTagLabel(Composite composite, ITag iTag) {
        Label label = new Label(composite, 0);
        label.setText(iTag.getName());
        final Color color = this.tagColorToColor((Device)label.getDisplay(), iTag.getNameColor());
        label.setForeground(color);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                color.dispose();
            }
        });
        return label;
    }

    private Color tagColorToColor(Device device, int n) {
        return new Color(device, n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }
}

