/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.intercept;

import com.subgraph.vega.api.http.proxy.IHttpInterceptor;
import com.subgraph.vega.api.http.proxy.IProxyTransaction;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.commands.InterceptQueueStateSourceProvider;
import com.subgraph.vega.ui.http.intercept.TransactionInfo;
import com.subgraph.vega.ui.http.intercept.TransactionManager;
import com.subgraph.vega.ui.http.intercept.TransactionViewer;
import com.subgraph.vega.ui.util.dialogs.ErrorDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.ISourceProviderService;

public class InterceptView
extends ViewPart {
    public static final String ID = "com.subgraph.vega.views.intercept";
    private SashForm parentComposite;
    private TransactionManager transactionManager;
    private TransactionInfo transactionInfo;
    private TransactionViewer transactionViewerRequest;
    private TransactionViewer transactionViewerResponse;

    public void createPartControl(Composite composite) {
        IHttpInterceptor iHttpInterceptor = Activator.getDefault().getProxyService().getInterceptor();
        IModel iModel = Activator.getDefault().getModel();
        this.parentComposite = new SashForm(composite, 512);
        this.transactionManager = new TransactionManager(this, iHttpInterceptor);
        IHttpRequestEngineFactory iHttpRequestEngineFactory = Activator.getDefault().getHttpRequestEngineFactoryService();
        this.transactionInfo = new TransactionInfo(iHttpRequestEngineFactory.createRequestBuilder(), iHttpRequestEngineFactory.createResponseBuilder());
        this.transactionManager.updateTransactionInfo(this.transactionInfo);
        this.transactionViewerRequest = new TransactionViewer((Composite)this.parentComposite, iModel, this.transactionInfo, IProxyTransaction.TransactionDirection.DIRECTION_REQUEST);
        this.transactionViewerResponse = new TransactionViewer((Composite)this.parentComposite, iModel, this.transactionInfo, IProxyTransaction.TransactionDirection.DIRECTION_RESPONSE);
        this.transactionManager.setManagerActive();
        this.parentComposite.setWeights(new int[]{50, 50});
        this.parentComposite.pack();
    }

    public void dispose() {
        if (this.transactionManager != null) {
            this.transactionManager.close();
        }
        super.dispose();
    }

    public void setFocus() {
    }

    public void openTransaction(IProxyTransaction iProxyTransaction) {
        this.transactionManager.openTransaction(iProxyTransaction);
    }

    public void notifyUpdate() {
        this.parentComposite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                InterceptView.this.doUpdate();
            }
        });
    }

    private void doUpdate() {
        this.transactionManager.updateTransactionInfo(this.transactionInfo);
        ISourceProviderService iSourceProviderService = (ISourceProviderService)this.getViewSite().getWorkbenchWindow().getService(ISourceProviderService.class);
        InterceptQueueStateSourceProvider interceptQueueStateSourceProvider = (InterceptQueueStateSourceProvider)iSourceProviderService.getSourceProvider("vega.interceptQueueState");
        if (this.transactionInfo.isPending()) {
            interceptQueueStateSourceProvider.setPending(true);
        } else {
            interceptQueueStateSourceProvider.setSent(this.transactionInfo.getRequestStatus() == TransactionManager.TransactionStatus.STATUS_SENT);
        }
        this.transactionViewerRequest.notifyUpdate();
        this.transactionViewerResponse.notifyUpdate();
    }

    public void forwardTransaction() {
        try {
            this.transactionViewerRequest.processChanges();
            this.transactionViewerResponse.processChanges();
            this.transactionManager.forwardTransaction(this.transactionInfo);
        }
        catch (Exception exception) {
            ErrorDialog.displayExceptionError((Shell)this.parentComposite.getShell(), (Exception)exception);
            return;
        }
    }

    public void dropTransaction() {
        try {
            this.transactionManager.dropTransaction(this.transactionInfo);
        }
        catch (Exception exception) {
            ErrorDialog.displayExceptionError((Shell)this.parentComposite.getShell(), (Exception)exception);
            return;
        }
    }
}

