/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.state;

import com.subgraph.vega.api.analysis.IContentAnalyzer;
import com.subgraph.vega.api.analysis.IContentAnalyzerResult;
import com.subgraph.vega.api.analysis.MimeType;
import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IPageFingerprint;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.api.scanner.modules.IBasicModuleScript;
import com.subgraph.vega.http.requests.custom.VegaHttpUriRequest;
import com.subgraph.vega.impl.scanner.requests.BasicRequestBuilder;
import com.subgraph.vega.impl.scanner.requests.GetParameterRequestBuilder;
import com.subgraph.vega.impl.scanner.requests.IRequestBuilder;
import com.subgraph.vega.impl.scanner.requests.PostParameterRequestBuilder;
import com.subgraph.vega.impl.scanner.state.CrawlerCallbackWrapper;
import com.subgraph.vega.impl.scanner.state.ModuleContext;
import com.subgraph.vega.impl.scanner.state.PathState404;
import com.subgraph.vega.impl.scanner.state.PathStateManager;
import com.subgraph.vega.impl.scanner.state.PathStateParameterManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;

public class PathState
implements IPathState {
    private final PathStateManager pathStateManager;
    private final IWebPath path;
    private final PathState parentState;
    private final List<PathState> childStates = new ArrayList<PathState>();
    private final IRequestBuilder requestBuilder;
    private final PathState404 state404;
    private final ICrawlerResponseProcessor initialFetchProcessor;
    private IHttpResponse response;
    private IPageFingerprint pathFingerprint;
    private IPageFingerprint unknownFingerprint;
    private boolean isDone;
    private boolean hasFailed404;
    private boolean hasBadParent;
    private boolean ipsDetected;
    private boolean isSureDirectory;
    private boolean isPageMissing;
    private boolean isBogusParameter;
    private boolean responseVaries;
    private boolean lockedFlag;
    private PathStateParameterManager parameterManager;
    private final Object childCountLock = new Object();
    private int descendantCount = 0;
    private int childCount = 0;
    private AtomicInteger outstandingRequests = new AtomicInteger();
    private AtomicInteger fuzzCounter = new AtomicInteger(0);
    private volatile boolean finishOnNoRequests;

    public static PathState createBasicPathState(ICrawlerResponseProcessor iCrawlerResponseProcessor, PathStateManager pathStateManager, PathState pathState, IWebPath iWebPath) {
        IHttpRequestEngine iHttpRequestEngine = pathStateManager.getCrawler().getRequestEngine();
        BasicRequestBuilder basicRequestBuilder = new BasicRequestBuilder(iHttpRequestEngine, iWebPath);
        PathState pathState2 = new PathState(iCrawlerResponseProcessor, pathStateManager, pathState, iWebPath, basicRequestBuilder);
        if (pathState != null) {
            pathState.addChildState(pathState2, true);
        } else {
            pathState2.setLocked();
            pathState2.performInitialFetch();
        }
        return pathState2;
    }

    public static PathState createParameterPathState(ICrawlerResponseProcessor iCrawlerResponseProcessor, PathState pathState, List<NameValuePair> list, int n) {
        if (pathState == null) {
            throw new IllegalArgumentException("Parent of parameter path cannot be null");
        }
        IHttpRequestEngine iHttpRequestEngine = pathState.getPathStateManager().getCrawler().getRequestEngine();
        GetParameterRequestBuilder getParameterRequestBuilder = new GetParameterRequestBuilder(iHttpRequestEngine, pathState.getPath(), list, n);
        PathState pathState2 = new PathState(iCrawlerResponseProcessor, pathState.getPathStateManager(), pathState, pathState.getPath(), getParameterRequestBuilder);
        pathState.addChildState(pathState2, false);
        return pathState2;
    }

    public static PathState createPostParameterPathState(ICrawlerResponseProcessor iCrawlerResponseProcessor, PathState pathState, List<NameValuePair> list, int n) {
        if (pathState == null) {
            throw new IllegalArgumentException("Parent of parameter path cannot be null");
        }
        IHttpRequestEngine iHttpRequestEngine = pathState.getPathStateManager().getCrawler().getRequestEngine();
        PostParameterRequestBuilder postParameterRequestBuilder = new PostParameterRequestBuilder(iHttpRequestEngine, pathState.getPath(), list, n);
        PathState pathState2 = new PathState(iCrawlerResponseProcessor, pathState.getPathStateManager(), pathState, pathState.getPath(), postParameterRequestBuilder);
        pathState.addChildState(pathState2, false);
        return pathState2;
    }

    private PathState(ICrawlerResponseProcessor iCrawlerResponseProcessor, PathStateManager pathStateManager, PathState pathState, IWebPath iWebPath, IRequestBuilder iRequestBuilder) {
        this.initialFetchProcessor = iCrawlerResponseProcessor;
        this.pathStateManager = pathStateManager;
        this.path = iWebPath;
        this.parentState = pathState;
        this.requestBuilder = iRequestBuilder;
        this.state404 = new PathState404(this);
    }

    public PathState getParentState() {
        return this.parentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildState(PathState pathState, boolean bl) {
        List<PathState> list = this.childStates;
        synchronized (list) {
            if (bl) {
                for (IPathState object2 : this.childStates) {
                    if (!object2.getPath().equals(pathState.getPath())) continue;
                    return;
                }
            }
            this.childStates.add(pathState);
            if (this.lockedFlag) {
                pathState.setLocked();
            } else {
                pathState.performInitialFetch();
            }
            Object object = this.childCountLock;
            synchronized (object) {
                ++this.childCount;
                this.incrementDescendants();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementDescendants() {
        Object object = this.childCountLock;
        synchronized (object) {
            ++this.descendantCount;
            if (this.parentState != null) {
                this.parentState.incrementDescendants();
            }
        }
    }

    public int getDescendantCount() {
        return this.descendantCount;
    }

    public int getChildCount() {
        return this.childCount;
    }

    public synchronized int getDepth() {
        if (this.parentState == null) {
            return 1;
        }
        return 1 + this.parentState.getDepth();
    }

    public PathStateManager getPathStateManager() {
        return this.pathStateManager;
    }

    public boolean isParametric() {
        return this.requestBuilder.isFuzzable();
    }

    public boolean isDone() {
        return this.isDone;
    }

    public synchronized void setDone() {
        if (!this.isDone) {
            this.isDone = true;
            this.response = null;
            this.pathStateManager.notifyPathNodeFinish(this);
        }
    }

    public void requeueInitialFetch() {
        if (this.lockedFlag) {
            return;
        }
        ModuleContext moduleContext = new ModuleContext(this.pathStateManager, this.requestBuilder, this, 0);
        HttpUriRequest httpUriRequest = this.createRequest();
        this.submitRequest(httpUriRequest, this.initialFetchProcessor, moduleContext);
    }

    private void setLocked() {
        this.lockedFlag = true;
    }

    private void performInitialFetch() {
        ModuleContext moduleContext = new ModuleContext(this.pathStateManager, this.requestBuilder, this, 0);
        HttpUriRequest httpUriRequest = this.createRequest();
        if (this.response != null) {
            this.initialFetchProcessor.processResponse(this.pathStateManager.getCrawler(), httpUriRequest, this.response, (Object)moduleContext);
        } else {
            this.submitRequest(httpUriRequest, this.initialFetchProcessor, moduleContext);
        }
        this.pathStateManager.notifyPathNodeStart(this);
    }

    public void setBogusParameter() {
        this.isBogusParameter = true;
    }

    public boolean isBogusParameter() {
        return this.isBogusParameter;
    }

    public IWebPath getPath() {
        return this.path;
    }

    public void setUnknownFingerprint(IPageFingerprint iPageFingerprint) {
        this.unknownFingerprint = iPageFingerprint;
    }

    public IPageFingerprint getUnknownFingerprint() {
        return this.unknownFingerprint;
    }

    public void submitRequest(ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        HttpUriRequest httpUriRequest = this.requestBuilder.createBasicRequest();
        IInjectionModuleContext iInjectionModuleContext = this.createModuleContext();
        this.submitRequest(httpUriRequest, iCrawlerResponseProcessor, iInjectionModuleContext);
    }

    public void submitRequest(HttpUriRequest httpUriRequest, ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        IInjectionModuleContext iInjectionModuleContext = this.createModuleContext();
        this.submitRequest(httpUriRequest, iCrawlerResponseProcessor, iInjectionModuleContext);
    }

    public void submitRequest(HttpUriRequest httpUriRequest, ICrawlerResponseProcessor iCrawlerResponseProcessor, IInjectionModuleContext iInjectionModuleContext) {
        this.incrementOutstandingRequests();
        this.pathStateManager.getCrawler().submitTask(httpUriRequest, this.getWrappedCallback(iCrawlerResponseProcessor), (Object)iInjectionModuleContext);
    }

    private ICrawlerResponseProcessor getWrappedCallback(ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        if (this.pathStateManager.requestLoggingEnabled()) {
            return CrawlerCallbackWrapper.createLogging(this, this.pathStateManager.getRequestLog(), iCrawlerResponseProcessor);
        }
        return CrawlerCallbackWrapper.create(this, iCrawlerResponseProcessor);
    }

    public HttpUriRequest createRequest() {
        return this.requestBuilder.createBasicRequest();
    }

    public HttpUriRequest createAlteredRequest(String string, boolean bl) {
        return this.requestBuilder.createAlteredRequest(string, bl);
    }

    public boolean hasMaximum404Fingerprints() {
        return this.state404.hasMaximum404Fingerprints();
    }

    public boolean add404Fingerprint(IPageFingerprint iPageFingerprint) {
        return this.state404.add404Fingerprint(iPageFingerprint);
    }

    public boolean isRootPath() {
        return this.path.getParentPath() == null;
    }

    public boolean has404Fingerprints() {
        return this.state404.has404Fingerprints();
    }

    public IPathState get404Parent() {
        return this.state404.get404Parent();
    }

    public boolean has404FingerprintMatching(IPageFingerprint iPageFingerprint) {
        return this.state404.has404FingerprintMatching(iPageFingerprint);
    }

    public boolean hasParent404Fingerprint(IPageFingerprint iPageFingerprint) {
        return this.state404.hasParent404Fingerprint(iPageFingerprint);
    }

    public void dump404Fingerprints() {
        this.state404.dumpFingerprints();
    }

    public boolean hasParent404FingerprintMatchingThis() {
        return this.state404.hasParent404Fingerprint(this.pathFingerprint);
    }

    public void setSureDirectory() {
        this.isSureDirectory = true;
    }

    public void clear404Fingerprints() {
        this.state404.clear404Fingerprints();
    }

    public void setSkip404() {
        this.state404.setSkip404();
    }

    public boolean getSkip404() {
        return this.state404.getSkip404();
    }

    public boolean isSureDirectory() {
        return this.isSureDirectory;
    }

    public void setResponse(IHttpResponse iHttpResponse) {
        this.response = iHttpResponse;
        if (iHttpResponse == null) {
            this.pathFingerprint = null;
            return;
        }
        this.pathFingerprint = iHttpResponse.getPageFingerprint();
        if (iHttpResponse.getResponseCode() == 200) {
            this.addWebResponseToPath(iHttpResponse);
        }
    }

    private void addWebResponseToPath(IHttpResponse iHttpResponse) {
        IContentAnalyzer iContentAnalyzer = this.pathStateManager.getContentAnalyzer();
        IContentAnalyzerResult iContentAnalyzerResult = iContentAnalyzer.processResponse(iHttpResponse, false, false);
        URI uRI = this.createRequest().getURI();
        String string = this.contentAnalyzerResultToMimeString(iContentAnalyzerResult);
        if (uRI.getQuery() == null) {
            if (this.path.getMimeType() == null && string != null) {
                this.path.setMimeType(string);
            }
            return;
        }
        this.path.addGetResponse(uRI.getQuery(), string);
    }

    private String contentAnalyzerResultToMimeString(IContentAnalyzerResult iContentAnalyzerResult) {
        if (iContentAnalyzerResult.getSniffedMimeType() != MimeType.MIME_NONE) {
            return iContentAnalyzerResult.getSniffedMimeType().getCanonicalName();
        }
        if (iContentAnalyzerResult.getDeclaredMimeType() != MimeType.MIME_NONE) {
            return iContentAnalyzerResult.getDeclaredMimeType().getCanonicalName();
        }
        return null;
    }

    public IHttpResponse getResponse() {
        return this.response;
    }

    public boolean isPageMissing() {
        return this.isPageMissing;
    }

    public void setPageMissing() {
        this.isPageMissing = true;
    }

    public void setResponseVaries() {
        this.responseVaries = true;
    }

    public boolean getResponseVaries() {
        return this.responseVaries;
    }

    public void debug(String string) {
        this.pathStateManager.debug("[" + this.path.getUri() + "] " + string);
    }

    public IPageFingerprint getPathFingerprint() {
        return this.pathFingerprint;
    }

    public boolean matchesPathFingerprint(IPageFingerprint iPageFingerprint) {
        if (this.pathFingerprint == null) {
            this.debug("Whoops no path fingerprint for " + this.path.getUri() + " : " + this);
            return false;
        }
        return this.pathFingerprint.isSame(iPageFingerprint);
    }

    public long getScanId() {
        return this.pathStateManager.getScanId();
    }

    public int allocateXssId() {
        return this.pathStateManager.allocateXssId();
    }

    public String createXssTag(int n) {
        return this.pathStateManager.createXssTag(n);
    }

    public String createXssTag(String string, int n) {
        return this.pathStateManager.createXssTag(string, n);
    }

    public String createXssPattern(int n) {
        return this.pathStateManager.createXssPattern(n);
    }

    public String createXssPattern(String string, int n) {
        return this.pathStateManager.createXssPattern(string, n);
    }

    public void registerXssRequest(HttpUriRequest httpUriRequest, int n) {
        this.pathStateManager.registerXssRequest(httpUriRequest, n);
    }

    public HttpUriRequest getXssRequest(int n, int n2) {
        return this.pathStateManager.getXssRequest(n, n2);
    }

    public NameValuePair getFuzzableParameter() {
        return this.requestBuilder.getFuzzableParameter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeAddParameters(List<NameValuePair> list) {
        PathStateParameterManager pathStateParameterManager;
        PathStateParameterManager pathStateParameterManager2 = pathStateParameterManager = this.getParameterManager();
        synchronized (pathStateParameterManager2) {
            if (list.size() > this.pathStateManager.getMaxParameterCount()) {
                return;
            }
            if (pathStateParameterManager.hasParameterList(list)) {
                if (this.isRescanNeeded()) {
                    this.rescanGetParameters(list, pathStateParameterManager);
                }
            } else if (!this.pathStateManager.hasExceededLimits(this)) {
                pathStateParameterManager.addParameterList(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeAddPostParameters(List<NameValuePair> list) {
        PathStateParameterManager pathStateParameterManager;
        PathStateParameterManager pathStateParameterManager2 = pathStateParameterManager = this.getParameterManager();
        synchronized (pathStateParameterManager2) {
            if (list.size() > this.pathStateManager.getMaxParameterCount()) {
                return;
            }
            if (!pathStateParameterManager.hasPostParameterList(list)) {
                pathStateParameterManager.addPostParameterList(list);
            } else if (this.isRescanNeeded()) {
                this.rescanPostParameters(list, pathStateParameterManager);
            }
        }
    }

    private boolean isRescanNeeded() {
        if (!this.pathStateManager.isProxyScan() || this.response == null) {
            return false;
        }
        IHttpRequestEngine iHttpRequestEngine = this.pathStateManager.getCrawler().getRequestEngine();
        List list = iHttpRequestEngine.getCookiesForRequest(this.response.getHost(), this.response.getOriginalRequest());
        return !this.sameCookies(list, this.response.getSentCookies());
    }

    private boolean sameCookies(List<Cookie> list, List<Cookie> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (Cookie cookie : list) {
            Cookie cookie2 = this.findFirstCookieByName(list2, cookie.getName());
            if (cookie2 != null) continue;
            return false;
        }
        return true;
    }

    private Cookie findFirstCookieByName(List<Cookie> list, String string) {
        for (Cookie cookie : list) {
            if (!cookie.getName().equalsIgnoreCase(string)) continue;
            return cookie;
        }
        return null;
    }

    private void rescanGetParameters(List<NameValuePair> list, PathStateParameterManager pathStateParameterManager) {
        this.rescanPathStates(pathStateParameterManager.getStatesForParameterList(list));
    }

    private void rescanPostParameters(List<NameValuePair> list, PathStateParameterManager pathStateParameterManager) {
        this.rescanPathStates(pathStateParameterManager.getStatesForPostParameterList(list));
    }

    private void rescanPathStates(List<PathState> list) {
        for (PathState pathState : list) {
            pathState.requeueInitialFetch();
        }
    }

    private synchronized PathStateParameterManager getParameterManager() {
        if (this.parameterManager == null) {
            this.parameterManager = new PathStateParameterManager(this);
        }
        return this.parameterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockChildren() {
        List<PathState> list = this.childStates;
        synchronized (list) {
            if (!this.lockedFlag) {
                return;
            }
            this.lockedFlag = false;
            for (PathState pathState : this.childStates) {
                pathState.performInitialFetch();
            }
        }
    }

    public String toString() {
        return "STATE: [" + this.requestBuilder + "]";
    }

    public IInjectionModuleContext createModuleContext() {
        return new ModuleContext(this.pathStateManager, this.requestBuilder, this);
    }

    public void setFailed404Detection() {
        this.hasFailed404 = true;
    }

    public boolean hasFailed404Detection() {
        return this.hasFailed404;
    }

    public void setBadParentDirectory() {
        this.hasBadParent = true;
    }

    public boolean hasBadParentDirectory() {
        return this.hasBadParent;
    }

    public boolean isIPSDetected() {
        return this.ipsDetected;
    }

    public void setIPSDetected() {
        this.ipsDetected = true;
    }

    public boolean doInjectionChecks() {
        if (this.isParametric()) {
            return true;
        }
        if (this.path.getPathType() == IWebPath.PathType.PATH_DIRECTORY) {
            return this.pathStateManager.getDirectoryInjectionChecksFlag();
        }
        return this.pathStateManager.getNonParameterFileInjectionChecksFlag();
    }

    public List<IBasicModuleScript> getInjectionModules() {
        return this.pathStateManager.getInjectionModules();
    }

    public IHttpRequestEngine getRequestEngine() {
        return this.pathStateManager.getCrawler().getRequestEngine();
    }

    public HttpUriRequest createRawRequest(HttpHost httpHost, String string, String string2) {
        VegaHttpUriRequest vegaHttpUriRequest = new VegaHttpUriRequest(httpHost, string, string2);
        return this.getRequestEngine().createRawRequest(httpHost, vegaHttpUriRequest.getRequestLine());
    }

    void incrementOutstandingRequests() {
        this.outstandingRequests.incrementAndGet();
    }

    public void decrementOutstandingRequests() {
        if (this.outstandingRequests.decrementAndGet() <= 0 && this.fuzzCounter.get() <= 0 && this.finishOnNoRequests) {
            this.setDone();
        }
    }

    public void incrementFuzzCounter() {
        this.fuzzCounter.incrementAndGet();
    }

    public void decrementFuzzCounter() {
        if (this.fuzzCounter.decrementAndGet() <= 0 && this.outstandingRequests.get() <= 0 && this.finishOnNoRequests) {
            this.setDone();
        }
    }

    public void setFinishOnNoRequests() {
        this.finishOnNoRequests = true;
        if (this.outstandingRequests.get() == 0) {
            this.setDone();
        }
    }
}

