/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting.tests;

import com.subgraph.vega.impl.scanner.modules.scripting.ModuleValidator;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptCompiler;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptFile;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptedModule;
import com.subgraph.vega.impl.scanner.modules.scripting.tests.QunitLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.mozilla.javascript.Scriptable;
import org.osgi.framework.Bundle;

public class TestScriptLoader {
    private final Logger logger = Logger.getLogger("script-loader");
    private final QunitLoader qunitLoader;
    private final ScriptCompiler moduleCompiler;
    private final Bundle bundle;
    private final List<ScriptedModule> allModules = new ArrayList<ScriptedModule>();

    public TestScriptLoader(Scriptable scriptable, Bundle bundle) {
        this.bundle = bundle;
        this.qunitLoader = new QunitLoader(scriptable, bundle);
        this.qunitLoader.load();
        this.moduleCompiler = new ScriptCompiler(this.qunitLoader.getScope());
    }

    public void load() {
        this.allModules.clear();
        for (URL uRL : this.allTestScripts()) {
            ScriptedModule scriptedModule = this.compileModule(new ScriptFile(uRL));
            if (scriptedModule == null || scriptedModule.isDisabled()) continue;
            this.allModules.add(scriptedModule);
        }
    }

    public List<ScriptedModule> getAllModules() {
        return Collections.unmodifiableList(this.allModules);
    }

    private ScriptedModule compileModule(ScriptFile scriptFile) {
        if (!this.moduleCompiler.compile(scriptFile) || scriptFile.getCompileStatus() != ScriptFile.CompileStatus.COMPILE_SUCCEEDED) {
            this.logger.warning(scriptFile.getCompileFailureMessage());
            return null;
        }
        ModuleValidator moduleValidator = this.validateModule(scriptFile.getCompiledScript(), scriptFile.getPath());
        if (moduleValidator == null) {
            return null;
        }
        return new ScriptedModule(scriptFile, "Test Modules", moduleValidator);
    }

    private ModuleValidator validateModule(Scriptable scriptable, String string) {
        ModuleValidator moduleValidator = new ModuleValidator(scriptable);
        try {
            moduleValidator.validate();
            return moduleValidator;
        }
        catch (ModuleValidator.ModuleValidationException moduleValidationException) {
            this.logger.warning("Failed to validate test module " + string + " :" + moduleValidationException.getMessage());
            return null;
        }
    }

    private List<URL> allTestScripts() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Enumeration enumeration = this.bundle.findEntries("/tests/scripts", "*", true);
        while (enumeration.hasMoreElements()) {
            URL uRL = (URL)enumeration.nextElement();
            arrayList.add(uRL);
        }
        return arrayList;
    }
}

