/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting.dom;

import com.subgraph.vega.impl.scanner.modules.scripting.dom.AttrJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.CharacterDataJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.CommentJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.DocumentJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.ElementJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.HTMLElementJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.NodeListJS;
import com.subgraph.vega.impl.scanner.modules.scripting.dom.TextJS;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.html2.HTMLDocument;
import org.w3c.dom.html2.HTMLElement;

public class NodeJS
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private Node node;
    private DocumentJS documentJS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NodeJS domNodeToJS(Node node, DocumentJS documentJS) {
        DocumentJS documentJS2 = documentJS;
        synchronized (documentJS2) {
            block6: {
                if (node != null) break block6;
                return null;
            }
            NodeJS nodeJS = documentJS.findCachedNode(node);
            if (nodeJS != null) {
                return nodeJS;
            }
            NodeJS nodeJS2 = NodeJS.createNodeJSFromDomNode(node, documentJS);
            if (nodeJS2 != null) {
                documentJS.putCachedNode(node, nodeJS2);
            }
            return nodeJS2;
        }
    }

    private static NodeJS createNodeJSFromDomNode(Node node, DocumentJS documentJS) {
        if (node == null) {
            return null;
        }
        if (node instanceof HTMLElement) {
            return HTMLElementJS.domHTMLElementToJS((HTMLElement)node, documentJS);
        }
        if (node instanceof HTMLDocument) {
            return documentJS;
        }
        if (node instanceof Comment) {
            return new CommentJS((Comment)node, documentJS);
        }
        if (node instanceof Text) {
            return new TextJS((Text)node, documentJS);
        }
        if (node instanceof CharacterData) {
            return new CharacterDataJS((CharacterData)node, documentJS);
        }
        if (node instanceof Attr) {
            return new AttrJS((Attr)node, documentJS);
        }
        if (node instanceof Document) {
            return documentJS;
        }
        if (node instanceof Element) {
            return new ElementJS((Element)node, documentJS);
        }
        return new NodeJS(node, documentJS);
    }

    public NodeJS() {
        this.node = null;
        this.documentJS = null;
    }

    public NodeJS(Node node, DocumentJS documentJS) {
        if (node == null) {
            throw new NullPointerException("Node cannot be null");
        }
        this.node = node;
        this.documentJS = documentJS;
    }

    protected void setNode(Node node) {
        this.node = node;
    }

    protected void setDocumentJS(DocumentJS documentJS) {
        this.documentJS = documentJS;
    }

    DocumentJS getDocumentJS() {
        return this.documentJS;
    }

    public void jsConstructor(Object object) {
    }

    protected void exportObject(Scriptable scriptable) {
        if (scriptable == null) {
            return;
        }
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope((Scriptable)this);
        scriptable.setParentScope(scriptable2);
        scriptable.setPrototype(ScriptableObject.getClassPrototype((Scriptable)scriptable2, (String)scriptable.getClassName()));
    }

    protected NodeJS exportNode(Node node) {
        if (node == null) {
            return null;
        }
        NodeJS nodeJS = NodeJS.domNodeToJS(node, this.documentJS);
        this.exportObject((Scriptable)nodeJS);
        return nodeJS;
    }

    protected NodeListJS exportNodeList(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        NodeListJS nodeListJS = new NodeListJS(nodeList, ScriptableObject.getTopLevelScope((Scriptable)this), this.documentJS);
        this.exportObject((Scriptable)nodeListJS);
        return nodeListJS;
    }

    private Scriptable createNodeArray(Object[] objectArray) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)this);
        Context context = Context.getCurrentContext();
        Scriptable scriptable2 = context.newArray(scriptable, objectArray);
        this.exportObject(scriptable2);
        return scriptable2;
    }

    public Scriptable jsGet_attributes() {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        Object[] objectArray = new Object[namedNodeMap.getLength()];
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            objectArray[n] = this.exportNode(namedNodeMap.item(n));
            ++n;
        }
        return this.createNodeArray(objectArray);
    }

    public Scriptable jsGet_childNodes() {
        return this.exportNodeList(this.node.getChildNodes());
    }

    public Scriptable jsGet_firstChild() {
        return this.exportNode(this.node.getFirstChild());
    }

    public Scriptable jsGet_lastChild() {
        return this.exportNode(this.node.getLastChild());
    }

    public String jsGet_localname() {
        return this.node.getLocalName();
    }

    public String jsGet_namespaceURI() {
        return this.node.getNamespaceURI();
    }

    public Scriptable jsGet_nextSibling() {
        return this.exportNode(this.node.getNextSibling());
    }

    public String jsGet_nodeName() {
        return this.node.getNodeName();
    }

    public int jsGet_nodeType() {
        return this.node.getNodeType();
    }

    public String jsGet_nodeValue() {
        return this.node.getNodeValue();
    }

    public Scriptable jsGet_ownerDocument() {
        return this.exportNode(this.node.getOwnerDocument());
    }

    public Scriptable jsGet_parentNode() {
        return this.exportNode(this.node.getParentNode());
    }

    public String jsGet_prefix() {
        return this.node.getPrefix();
    }

    public Scriptable jsGet_previousSibling() {
        return this.exportNode(this.node.getPreviousSibling());
    }

    public Scriptable jsFunction_appendChild(Scriptable scriptable) throws DOMException {
        return null;
    }

    public Scriptable jsFunction_cloneNode(boolean bl) {
        return null;
    }

    public boolean jsFunction_hasAttributes() {
        return this.node.hasAttributes();
    }

    public boolean jsFunction_hasChildNodes() {
        return this.node.hasChildNodes();
    }

    public Scriptable jsFunction_insertBefore(Scriptable scriptable, Scriptable scriptable2) throws DOMException {
        return null;
    }

    public boolean jsFunction_isSupported(String string, String string2) {
        return this.node.isSupported(string, string2);
    }

    public void jsFunction_normalize() {
        this.node.normalize();
    }

    public Scriptable jsFunction_removeChild(Scriptable scriptable) throws DOMException {
        return null;
    }

    public Scriptable jsFunction_replaceChild(Scriptable scriptable, Scriptable scriptable2) throws DOMException {
        return null;
    }

    public String getClassName() {
        return "Node";
    }

    public static void finishInit(Scriptable scriptable, FunctionObject functionObject, Scriptable scriptable2) {
        functionObject.defineProperty("ELEMENT_NODE", (Object)1, 1);
        functionObject.defineProperty("ATTRIBUTE_NODE", (Object)2, 1);
        functionObject.defineProperty("TEXT_NODE", (Object)3, 1);
        functionObject.defineProperty("CDATA_SECTION_NODE", (Object)4, 1);
        functionObject.defineProperty("PROCESSING_INSTRUCTION_NODE", (Object)7, 1);
        functionObject.defineProperty("COMMENT_NODE", (Object)8, 1);
        functionObject.defineProperty("DOCUMENT_NODE", (Object)9, 1);
        functionObject.defineProperty("DOCUMENT_TYPE_NODE", (Object)10, 1);
        functionObject.defineProperty("DOCUMENT_FRAGMENT_NODE", (Object)11, 1);
    }

    public int jsFunction_compareDocumentPosition(Scriptable scriptable) {
        if (!(scriptable instanceof NodeJS)) {
            throw Context.reportRuntimeError((String)"compareDocumentPosition must be called with a Node argument");
        }
        Node node = ((NodeJS)scriptable).node;
        return this.node.compareDocumentPosition(node);
    }
}

