/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.scanner.modules.IEnableableModule;
import com.subgraph.vega.api.scanner.modules.IResponseProcessingModule;
import com.subgraph.vega.impl.scanner.modules.scripting.ResponseModuleContext;
import com.subgraph.vega.impl.scanner.modules.scripting.RhinoExceptionFormatter;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptedModule;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptedModuleRunningTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpRequest;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;

public class ResponseProcessorScript
implements IResponseProcessingModule,
IEnableableModule {
    private static final Logger logger = Logger.getLogger("modules");
    private final ScriptedModule module;
    private final ScriptedModuleRunningTime runningTime;
    private boolean isEnabled;

    public ResponseProcessorScript(ScriptedModule scriptedModule, boolean bl, ScriptedModuleRunningTime scriptedModuleRunningTime) {
        this.module = scriptedModule;
        this.isEnabled = bl;
        this.runningTime = scriptedModuleRunningTime;
    }

    public ResponseProcessorScript(ScriptedModule scriptedModule) {
        this.module = scriptedModule;
        this.isEnabled = scriptedModule.isDefaultEnabled();
        this.runningTime = new ScriptedModuleRunningTime(scriptedModule.getModuleName());
    }

    public ScriptedModule getModule() {
        return this.module;
    }

    public void processResponse(IScanInstance iScanInstance, HttpRequest httpRequest, IHttpResponse iHttpResponse, IWorkspace iWorkspace) {
        ResponseModuleContext responseModuleContext = new ResponseModuleContext(iWorkspace, iScanInstance);
        try {
            try {
                Context context = Context.enter();
                Scriptable scriptable = this.module.createInstanceScope(context);
                Object[] objectArray = new Object[]{httpRequest, this.createResponse(iHttpResponse, context, scriptable), responseModuleContext};
                long l = System.currentTimeMillis();
                this.module.runModule(context, scriptable, objectArray);
                long l2 = System.currentTimeMillis();
                this.runningTime.addTimestamp((int)(l2 - l), httpRequest.getRequestLine().getUri());
            }
            catch (WrappedException wrappedException) {
                logger.log(Level.WARNING, new RhinoExceptionFormatter("Wrapped exception running module script: " + this.module.getModuleName(), (RhinoException)((Object)wrappedException)).toString());
                Context.exit();
            }
            catch (RhinoException rhinoException) {
                rhinoException.printStackTrace();
                logger.warning(new RhinoExceptionFormatter("Exception running module script: " + this.module.getModuleName(), rhinoException).toString());
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    private Scriptable createResponse(IHttpResponse iHttpResponse, Context context, Scriptable scriptable) {
        Object object = Context.javaToJS((Object)iHttpResponse, (Scriptable)scriptable);
        Object[] objectArray = new Object[]{object};
        return context.newObject(scriptable, "Response", objectArray);
    }

    public boolean responseCodeFilter(int n) {
        return true;
    }

    public boolean mimeTypeFilter(String string) {
        return string.toLowerCase().matches("^.*?(text|html|script|xml|json).*$");
    }

    public String getModuleName() {
        return this.module.getModuleName();
    }

    public String getModuleCategoryName() {
        return this.module.getCategoryName();
    }

    public ScriptedModuleRunningTime getRunningTimeProfile() {
        return this.runningTime;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isDifferential() {
        return false;
    }

    public boolean isTimeSensitive() {
        return false;
    }
}

