/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.macros.macrosview.tree;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.macros.IHttpMacro;
import com.subgraph.vega.api.model.macros.IHttpMacroModel;
import com.subgraph.vega.api.model.macros.NewMacroEvent;
import com.subgraph.vega.ui.macros.macrosview.tree.IMacroTreeNode;
import com.subgraph.vega.ui.macros.macrosview.tree.MacroTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class MacroViewerContentProvider
implements ITreeContentProvider,
IEventHandler {
    private IHttpMacroModel macroModel;
    private Viewer viewer;
    private final List<IMacroTreeNode> childrenList = new ArrayList<IMacroTreeNode>();

    public void dispose() {
        if (this.macroModel != null) {
            this.macroModel.removeChangeListener((IEventHandler)this);
        }
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.viewer = viewer;
        if (object2 != object) {
            if (this.macroModel != null) {
                this.macroModel.removeChangeListener((IEventHandler)this);
                this.childrenList.clear();
            }
            this.macroModel = (IHttpMacroModel)object2;
            if (this.macroModel != null) {
                this.macroModel.addChangeListener((IEventHandler)this);
                for (IHttpMacro iHttpMacro : this.macroModel.getAllMacros()) {
                    this.childrenList.add(new MacroTreeNode(iHttpMacro));
                }
            }
        }
    }

    public Object[] getElements(Object object) {
        return this.childrenList.toArray();
    }

    public Object[] getChildren(Object object) {
        return ((IMacroTreeNode)object).getChildren();
    }

    public Object getParent(Object object) {
        return null;
    }

    public boolean hasChildren(Object object) {
        return ((IMacroTreeNode)object).hasChildren();
    }

    public void handleEvent(IEvent iEvent) {
        if (iEvent instanceof NewMacroEvent) {
            this.childrenList.add(new MacroTreeNode(((NewMacroEvent)iEvent).getMacro()));
            this.viewer.refresh();
        }
    }
}

