/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting.tests;

import com.subgraph.vega.api.html.IHTMLParseResult;
import com.subgraph.vega.api.html.IHTMLParser;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.impl.scanner.modules.scripting.AbstractScriptModule;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptedModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.osgi.framework.Bundle;

public class DomTestModule
extends AbstractScriptModule {
    private final Bundle bundle;
    private final ScriptedModule testScript;
    private final IHTMLParser htmlParser;

    public DomTestModule(ScriptedModule scriptedModule, Bundle bundle, IHTMLParser iHTMLParser) {
        super(scriptedModule);
        this.testScript = scriptedModule;
        this.bundle = bundle;
        this.htmlParser = iHTMLParser;
    }

    public void run(IWorkspace iWorkspace) throws IOException {
        String string = this.lookupModuleString("html");
        IHTMLParseResult iHTMLParseResult = this.loadHTML(string);
        ArrayList<AbstractScriptModule.ExportedObject> arrayList = new ArrayList<AbstractScriptModule.ExportedObject>();
        this.export(arrayList, "testDom", iHTMLParseResult.getDOMDocument());
        this.export(arrayList, "workspace", iWorkspace);
        this.runScript(arrayList, "domtest");
    }

    private String lookupModuleString(String string) {
        Scriptable scriptable = this.getModuleObject();
        Object object = scriptable.get(string, this.testScript.getModuleScope());
        if (object == Scriptable.NOT_FOUND) {
            throw new IllegalArgumentException("Could not find " + string);
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Property " + string + " is not a string");
        }
        return (String)object;
    }

    private Scriptable getModuleObject() {
        Scriptable scriptable = this.testScript.getModuleScope();
        Object object = scriptable.get("module", scriptable);
        if (object == Scriptable.NOT_FOUND) {
            throw new IllegalArgumentException();
        }
        return Context.toObject((Object)object, (Scriptable)scriptable);
    }

    IHTMLParseResult loadHTML(String string) throws IOException {
        URL uRL = this.bundle.getEntry("/tests/html/" + string);
        if (uRL == null) {
            throw new FileNotFoundException("Could not locate test html file /data/test/" + string);
        }
        InputStream inputStream = uRL.openStream();
        String string2 = this.streamToString(inputStream);
        return this.htmlParser.parseString(string2, null);
    }

    String streamToString(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[2048];
        int n;
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringWriter.write(cArray, 0, n);
        }
        return stringWriter.toString();
    }

    public boolean isDifferential() {
        return false;
    }

    public boolean isTimeSensitive() {
        return false;
    }
}

