/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.google.common.io.BaseEncoding;
import com.google.common.net.InternetDomainName;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.requests.IRequestLog;
import com.subgraph.vega.api.scanner.IModuleContext;
import com.subgraph.vega.impl.scanner.modules.scripting.ResponseJS;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class ResponseModuleContext
implements IModuleContext {
    private static final Logger logger = Logger.getLogger("modules");
    private final IWorkspace workspace;
    private final IScanInstance scanInstance;
    private final List<String> stringHighlights;
    private final List<String> regexHighlights;
    private final List<String> regexCaseInsensitiveHighlights;

    ResponseModuleContext(IWorkspace iWorkspace, IScanInstance iScanInstance) {
        this.workspace = iWorkspace;
        this.scanInstance = iScanInstance;
        this.stringHighlights = new ArrayList<String>();
        this.regexHighlights = new ArrayList<String>();
        this.regexCaseInsensitiveHighlights = new ArrayList<String>();
    }

    public void reportRequestException(HttpUriRequest httpUriRequest, Throwable throwable) {
        logger.warning("Exception processing request " + httpUriRequest + " : " + throwable.getMessage());
        this.scanInstance.notifyScanException(httpUriRequest, throwable);
    }

    public void error(HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, String string) {
        long l = this.workspace.getRequestLog().addRequestResponse(iHttpResponse);
        logger.warning("Error running module: " + string + " (request logged with id=" + l + ")");
    }

    public void error(HttpUriRequest httpUriRequest, ResponseJS responseJS, String string) {
        this.error(httpUriRequest, responseJS.getResponse(), string);
    }

    public void debug(String string) {
        this.workspace.consoleWrite(string);
    }

    public void debug(String string, Boolean bl) {
        if (bl.booleanValue()) {
            this.workspace.consoleDebug(string);
        } else {
            this.workspace.consoleWrite(string);
        }
    }

    public void alert(String string, HttpUriRequest httpUriRequest, ResponseJS responseJS) {
        this.alert(string, (HttpRequest)httpUriRequest, responseJS, null);
    }

    public void alert(String string, HttpRequest httpRequest, ResponseJS responseJS, Scriptable scriptable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        String string3 = null;
        if (scriptable == null) {
            this.publishAlert(string, null, httpRequest, responseJS.getResponse(), new Object[0]);
            return;
        }
        Object[] objectArray = scriptable.getIds();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string4;
            String string5;
            Object object = objectArray[n2];
            if (object instanceof String && (string5 = this.lookup(string4 = (String)object, scriptable)) != null) {
                if ("key".equals(string4)) {
                    string2 = string5;
                } else if ("message".equals(string4)) {
                    string3 = string5;
                } else {
                    arrayList.add(string4);
                    arrayList.add(string5);
                }
            }
            ++n2;
        }
        this.publishAlert(string, string2, string3, httpRequest, responseJS.getResponse(), arrayList.toArray());
    }

    private String lookup(String string, Scriptable scriptable) {
        Object object = scriptable.get(string, scriptable);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)object;
            if (wrapper.unwrap() instanceof String) {
                return (String)wrapper.unwrap();
            }
            return null;
        }
        return null;
    }

    public void publishAlert(String string, String string2, HttpRequest httpRequest, IHttpResponse iHttpResponse, Object ... objectArray) {
        this.publishAlert(string, null, string2, httpRequest, iHttpResponse, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAlert(String string, String string2, String string3, HttpRequest httpRequest, IHttpResponse iHttpResponse, Object ... objectArray) {
        this.debug("Publishing Alert: (" + string + ") [" + httpRequest.getRequestLine().getUri() + "] ");
        IRequestLog iRequestLog = this.workspace.getRequestLog();
        IScanInstance iScanInstance = this.scanInstance;
        synchronized (iScanInstance) {
            if (string2 != null && this.scanInstance.hasAlertKey(string2)) {
                return;
            }
            long l = iRequestLog.addRequestResponse(iHttpResponse);
            IScanAlert iScanAlert = this.scanInstance.createAlert(string, string2, l);
            int n = 0;
            while (n + 1 < objectArray.length) {
                if (objectArray[n] instanceof String) {
                    iScanAlert.setProperty((String)objectArray[n], objectArray[n + 1]);
                } else {
                    logger.warning("Property key passed to publishAlert() is not a string");
                }
                n += 2;
            }
            if (string3 != null) {
                iScanAlert.setStringProperty("message", string3);
            }
            for (String string4 : this.stringHighlights) {
                iScanAlert.addStringMatchHighlight(string4);
            }
            for (String string5 : this.regexHighlights) {
                iScanAlert.addRegexHighlight(string5);
            }
            for (String string6 : this.regexCaseInsensitiveHighlights) {
                iScanAlert.addRegexCaseInsensitiveHighlight(string6);
            }
            this.scanInstance.addAlert(iScanAlert);
        }
    }

    public void setProperty(String string, Object object) {
        this.scanInstance.setProperty(string, object);
    }

    public void setStringProperty(String string, String string2) {
        this.scanInstance.setStringProperty(string, string2);
    }

    public void setIntegerProperty(String string, int n) {
        this.scanInstance.setIntegerProperty(string, n);
    }

    public Object getProperty(String string) {
        return this.scanInstance.getProperty(string);
    }

    public String getStringProperty(String string) {
        return this.scanInstance.getStringProperty(string);
    }

    public Integer getIntegerProperty(String string) {
        return this.scanInstance.getIntegerProperty(string);
    }

    public List<String> propertyKeys() {
        return this.scanInstance.propertyKeys();
    }

    public void addStringHighlight(String string) {
        this.stringHighlights.add(string);
    }

    public void addRegexHighlight(String string) {
        try {
            Pattern.compile(string);
            this.regexHighlights.add(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            logger.warning("Invalid regular expression '" + string + "' passed to addHighlightRegex(): " + patternSyntaxException.getDescription());
        }
    }

    public void addRegexCaseInsensitiveHighlight(String string) {
        try {
            Pattern.compile(string);
            this.regexCaseInsensitiveHighlights.add(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            logger.warning("Invalid regular expression '" + string + "' passed to addRegexCaseInsensitiveHighlights(): " + patternSyntaxException.getDescription());
        }
    }

    public void reset() {
        this.stringHighlights.clear();
        this.regexHighlights.clear();
    }

    public boolean alertExists(String string) {
        return this.scanInstance.hasAlertKey(string);
    }

    public InternetDomainName internetDomainName(String string) {
        return InternetDomainName.from((String)string);
    }

    public boolean isValidInternetDomainName(String string) {
        return InternetDomainName.isValid((String)string);
    }

    public String base64decode(String string) {
        byte[] byArray = BaseEncoding.base64().decode((CharSequence)string);
        return new String(byArray);
    }

    public String base64encode(String string) {
        String string2 = BaseEncoding.base64().encode(string.getBytes());
        return string2;
    }

    public long getScanId() {
        return this.scanInstance.getScanId();
    }
}

