/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.impl.scanner.modules.scripting.ModuleContextJS;
import com.subgraph.vega.impl.scanner.modules.scripting.RhinoExceptionFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.methods.HttpUriRequest;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;

public class CrawlerCallbackWrapper
implements ICrawlerResponseProcessor {
    private static final Logger logger = Logger.getLogger("scanner");
    private static final long serialVersionUID = 1L;
    private Function callbackFunction;

    public CrawlerCallbackWrapper(Function function) {
        this.callbackFunction = function;
    }

    public void processResponse(IWebCrawler iWebCrawler, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse, Object object) {
        boolean cfr_ignored_0 = object instanceof IInjectionModuleContext;
        IInjectionModuleContext iInjectionModuleContext = (IInjectionModuleContext)object;
        Scriptable scriptable = this.callbackFunction.getParentScope();
        try {
            try {
                Context context = Context.enter();
                Object[] objectArray = new Object[]{httpUriRequest, this.createResponse(iHttpResponse, context, scriptable), new ModuleContextJS(scriptable, iInjectionModuleContext)};
                this.callbackFunction.call(context, scriptable, scriptable, objectArray);
            }
            catch (WrappedException wrappedException) {
                logger.log(Level.WARNING, new RhinoExceptionFormatter("Wrapped exception running module script", (RhinoException)((Object)wrappedException)).toString());
                wrappedException.printStackTrace();
                Context.exit();
            }
            catch (RhinoException rhinoException) {
                logger.warning(new RhinoExceptionFormatter("Exception running module script.", rhinoException).toString());
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    private Scriptable createResponse(IHttpResponse iHttpResponse, Context context, Scriptable scriptable) {
        Object object = Context.javaToJS((Object)iHttpResponse, (Scriptable)scriptable);
        Object[] objectArray = new Object[]{object};
        return context.newObject(scriptable, "Response", objectArray);
    }

    public void processException(HttpUriRequest httpUriRequest, Throwable throwable, Object object) {
        IInjectionModuleContext iInjectionModuleContext = (IInjectionModuleContext)object;
        iInjectionModuleContext.reportRequestException(httpUriRequest, throwable);
    }
}

