/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.paths;

import com.subgraph.vega.api.paths.IPathFinder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathFinder
implements IPathFinder {
    private final Logger logger = Logger.getLogger("paths");
    private final Properties configProperties = new Properties();

    public File getVegaDirectory() {
        File file = new File(System.getProperty("user.home"));
        return new File(file, ".vega");
    }

    public File getWorkspaceDirectory() {
        return new File(this.getVegaDirectory(), "workspaces");
    }

    public File getConfigFilePath() {
        return new File(this.getVegaDirectory(), "config");
    }

    public File getDataDirectory() {
        File file = this.getDataDirectoryFromConfig();
        if (file != null) {
            return file;
        }
        if (this.isRunningInEclipse()) {
            return this.getDataDirectoryForEclipseLaunch();
        }
        return this.getInstallDataDirectory();
    }

    private boolean isRunningInEclipse() {
        return System.getProperty("osgi.dev") != null;
    }

    private File getDataDirectoryForEclipseLaunch() {
        String string = System.getProperty("osgi.splashPath");
        File file = new File(this.fileURLTrim(string));
        return file.getParentFile().getParentFile();
    }

    private File getInstallDataDirectory() {
        String string = System.getProperty("osgi.install.area");
        return new File(this.fileURLTrim(string));
    }

    private String fileURLTrim(String string) {
        return string.startsWith("file:") ? string.substring(5) : string;
    }

    private File getDataDirectoryFromConfig() {
        File file;
        this.loadConfigProperties();
        String string = this.configProperties.getProperty("vega.scanner.datapath");
        if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    private void loadConfigProperties() {
        block13: {
            File file = this.getConfigFilePath();
            if (!file.exists() || !file.canRead()) {
                return;
            }
            FileReader fileReader = null;
            try {
                try {
                    fileReader = new FileReader(file);
                    this.configProperties.clear();
                    this.configProperties.load(fileReader);
                }
                catch (IOException iOException) {
                    this.logger.log(Level.WARNING, "Error opening config file: " + iOException.getMessage(), iOException);
                    if (fileReader == null) break block13;
                    try {
                        ((Reader)fileReader).close();
                    }
                    catch (IOException iOException2) {
                        this.logger.log(Level.WARNING, "Error closing config file: " + iOException2.getMessage(), iOException2);
                    }
                }
            }
            finally {
                if (fileReader != null) {
                    try {
                        ((Reader)fileReader).close();
                    }
                    catch (IOException iOException) {
                        this.logger.log(Level.WARNING, "Error closing config file: " + iOException.getMessage(), iOException);
                    }
                }
            }
        }
    }
}

