/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.info;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.alerts.ActiveScanInstanceEvent;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.alerts.RemoveScanAlertsEvent;
import com.subgraph.vega.api.model.alerts.RemoveScanInstanceEvent;
import com.subgraph.vega.api.paths.IPathFinder;
import com.subgraph.vega.ui.scanner.Activator;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertScanNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertTitleNode;
import com.subgraph.vega.ui.scanner.dashboard.DashboardPane;
import com.subgraph.vega.ui.scanner.info.AlertRenderer;
import com.subgraph.vega.ui.scanner.info.LinkHandler;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

public class ScanInfoView
extends ViewPart
implements IEventHandler {
    private final Logger logger = Logger.getLogger("info-view");
    public static String ID = "com.subgraph.vega.views.scaninfo";
    private Browser browser;
    private IScanAlert currentBrowserAlert;
    private DashboardPane dashboard;
    private Composite contentPanel;
    private final AlertRenderer renderer;
    private StackLayout stackLayout = new StackLayout();
    private BrowserFunction linkClick;
    private IWorkspace currentWorkspace;

    public ScanInfoView() {
        TemplateLoader templateLoader = this.createTemplateLoader();
        this.renderer = templateLoader == null ? null : new AlertRenderer(templateLoader);
    }

    private TemplateLoader createTemplateLoader() {
        IPathFinder iPathFinder = Activator.getDefault().getPathFinder();
        if (iPathFinder == null) {
            throw new IllegalStateException("Cannot find templates to render because path finder service is not available");
        }
        File file = new File(iPathFinder.getDataDirectory(), "templates");
        try {
            return new FileTemplateLoader(file);
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "Failed to open template directory: " + iOException.getMessage());
            return null;
        }
    }

    public void createPartControl(Composite composite) {
        IStructuredSelection iStructuredSelection;
        this.contentPanel = new Composite(composite, 0);
        this.contentPanel.setLayout((Layout)this.stackLayout);
        this.dashboard = new DashboardPane(this.contentPanel);
        this.browser = new Browser(this.contentPanel, 0);
        this.browser.setJavascriptEnabled(true);
        this.linkClick = new LinkHandler(this.browser, (IServiceLocator)this.getSite());
        this.getSite().getPage().addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
                AlertTitleNode alertTitleNode;
                if (!(iSelection instanceof IStructuredSelection)) {
                    return;
                }
                Object object = ((IStructuredSelection)iSelection).getFirstElement();
                if (object instanceof IScanAlert) {
                    IScanAlert iScanAlert = (IScanAlert)object;
                    ScanInfoView.this.displayAlert(iScanAlert);
                } else if (object instanceof AlertScanNode) {
                    AlertScanNode alertScanNode = (AlertScanNode)object;
                    ScanInfoView.this.displayScanSummary(alertScanNode.getScanInstance());
                } else if (object instanceof AlertTitleNode && (alertTitleNode = (AlertTitleNode)object).getAlertCount() == 1) {
                    ScanInfoView.this.displayAlert(alertTitleNode.getFirstAlert());
                }
            }
        });
        this.stackLayout.topControl = this.dashboard;
        this.contentPanel.layout();
        IModel iModel = Activator.getDefault().getModel();
        if (iModel != null) {
            this.setCurrentWorkspace(iModel.addWorkspaceListener((IEventHandler)this));
        }
        if ((iStructuredSelection = (IStructuredSelection)this.getSite().getPage().getSelection("com.subgraph.vega.views.alert")) != null && iStructuredSelection.getFirstElement() instanceof AlertScanNode) {
            AlertScanNode alertScanNode = (AlertScanNode)iStructuredSelection.getFirstElement();
            this.displayScanSummary(alertScanNode.getScanInstance());
        }
    }

    private void resetState() {
        this.browser.setText("");
        this.dashboard.displayScanInstance(null);
        this.showDashboard();
    }

    private void displayAlert(IScanAlert iScanAlert) {
        String string = this.renderer.render(iScanAlert);
        if (string != null && !this.browser.isDisposed()) {
            this.browser.setText(string, true);
            this.currentBrowserAlert = iScanAlert;
        }
        this.stackLayout.topControl = this.browser;
        this.contentPanel.layout();
    }

    private void displayScanSummary(final IScanInstance iScanInstance) {
        if (iScanInstance == null) {
            return;
        }
        if (!this.dashboard.getDisplay().isDisposed()) {
            this.dashboard.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ScanInfoView.this.dashboard.displayScanInstance(iScanInstance);
                    ScanInfoView.this.showDashboard();
                }
            });
        }
    }

    public void showDashboard() {
        this.currentBrowserAlert = null;
        this.stackLayout.topControl = this.dashboard;
        if (!this.contentPanel.isDisposed()) {
            this.contentPanel.layout();
        }
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        if (this.linkClick != null) {
            this.linkClick.dispose();
        }
        super.dispose();
    }

    public void handleEvent(IEvent iEvent) {
        if (iEvent instanceof WorkspaceOpenEvent) {
            this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
        } else if (iEvent instanceof WorkspaceCloseEvent) {
            this.handleWorkspaceCloseEvent((WorkspaceCloseEvent)iEvent);
        } else if (iEvent instanceof WorkspaceResetEvent) {
            this.handleWorkspaceResetEvent((WorkspaceResetEvent)iEvent);
        } else if (iEvent instanceof ActiveScanInstanceEvent) {
            this.handleActiveScanInstance((ActiveScanInstanceEvent)iEvent);
        } else if (iEvent instanceof RemoveScanAlertsEvent) {
            this.handleRemoveScanAlertsEvent((RemoveScanAlertsEvent)iEvent);
        } else if (iEvent instanceof RemoveScanInstanceEvent) {
            this.handleRemoveScanInstanceEvent((RemoveScanInstanceEvent)iEvent);
        }
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.setCurrentWorkspace(workspaceOpenEvent.getWorkspace());
    }

    private void handleWorkspaceCloseEvent(WorkspaceCloseEvent workspaceCloseEvent) {
        this.setCurrentWorkspace(null);
        this.resetState();
    }

    private void handleWorkspaceResetEvent(WorkspaceResetEvent workspaceResetEvent) {
        this.setCurrentWorkspace(workspaceResetEvent.getWorkspace());
        this.resetState();
    }

    private void handleActiveScanInstance(ActiveScanInstanceEvent activeScanInstanceEvent) {
        this.setActiveScanInstance(activeScanInstanceEvent.getScanInstance());
    }

    private void handleRemoveScanAlertsEvent(RemoveScanAlertsEvent removeScanAlertsEvent) {
        if (this.currentBrowserAlert != null) {
            for (IScanAlert iScanAlert : removeScanAlertsEvent.getRemovedEvents()) {
                if (iScanAlert != this.currentBrowserAlert) continue;
                this.resetState();
            }
        }
        this.dashboard.reset();
    }

    private void handleRemoveScanInstanceEvent(RemoveScanInstanceEvent removeScanInstanceEvent) {
        if (this.currentBrowserAlert != null && this.currentBrowserAlert.getScanId() == removeScanInstanceEvent.getScanInstance().getScanId()) {
            this.resetState();
        }
        if (this.stackLayout.topControl == this.dashboard && this.dashboard.getScanInstance() == removeScanInstanceEvent.getScanInstance()) {
            this.resetState();
        }
    }

    private void setCurrentWorkspace(IWorkspace iWorkspace) {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.getScanAlertRepository().removeActiveScanInstanceListener((IEventHandler)this);
        }
        if (iWorkspace == null) {
            this.setActiveScanInstance(null);
            this.currentWorkspace = null;
            return;
        }
        List list = iWorkspace.getScanAlertRepository().addActiveScanInstanceListener((IEventHandler)this);
        if (list.size() != 0) {
            this.setActiveScanInstance((IScanInstance)list.get(0));
        }
        this.currentWorkspace = iWorkspace;
    }

    private void setActiveScanInstance(IScanInstance iScanInstance) {
        this.displayScanSummary(iScanInstance);
    }
}

