/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.api.http.proxy.IHttpInterceptProxyEventHandler;
import com.subgraph.vega.api.http.proxy.IHttpProxyListener;
import com.subgraph.vega.api.http.proxy.IHttpProxyListenerConfig;
import com.subgraph.vega.api.http.proxy.IProxyTransaction;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.internal.http.proxy.ConnectionTask;
import com.subgraph.vega.internal.http.proxy.HttpInterceptor;
import com.subgraph.vega.internal.http.proxy.ProxyRequestHandler;
import com.subgraph.vega.internal.http.proxy.ProxyTransaction;
import com.subgraph.vega.internal.http.proxy.ProxyTransactionManipulator;
import com.subgraph.vega.internal.http.proxy.ResponseContentCustom;
import com.subgraph.vega.internal.http.proxy.VegaHttpServerConnection;
import com.subgraph.vega.internal.http.proxy.VegaHttpService;
import com.subgraph.vega.internal.http.proxy.ssl.SSLContextRepository;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.ResponseConnControl;

public class HttpProxyListener
implements IHttpProxyListener {
    static final String PROXY_CONTEXT_REQUEST = "proxy.request";
    static final String PROXY_CONTEXT_RESPONSE = "proxy.response";
    static final String PROXY_HTTP_HOST = "proxy.host";
    static final String PROXY_HTTP_TRANSACTION = "proxy.transaction";
    private final Logger logger = Logger.getLogger("proxy");
    private IHttpProxyListenerConfig config;
    private final ProxyTransactionManipulator transactionManipulator;
    private final HttpInterceptor interceptor;
    private final IHttpRequestEngine requestEngine;
    private final List<IHttpInterceptProxyEventHandler> eventHandlers;
    private ServerSocket serverSocket;
    private HttpParams params;
    private VegaHttpService httpService;
    private ExecutorService executor;
    private Thread proxyThread;
    private final List<ConnectionTask> connectionList;

    public HttpProxyListener(IHttpProxyListenerConfig iHttpProxyListenerConfig, ProxyTransactionManipulator proxyTransactionManipulator, HttpInterceptor httpInterceptor, IHttpRequestEngine iHttpRequestEngine, SSLContextRepository sSLContextRepository) {
        this.config = iHttpProxyListenerConfig;
        this.transactionManipulator = proxyTransactionManipulator;
        this.interceptor = httpInterceptor;
        this.requestEngine = iHttpRequestEngine;
        this.eventHandlers = new ArrayList<IHttpInterceptProxyEventHandler>();
        this.params = new BasicHttpParams();
        this.params.setIntParameter("http.socket.timeout", 0).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.tcp.nodelay", true);
        BasicHttpProcessor basicHttpProcessor = new BasicHttpProcessor();
        basicHttpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        basicHttpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContentCustom());
        HttpRequestHandlerRegistry httpRequestHandlerRegistry = new HttpRequestHandlerRegistry();
        httpRequestHandlerRegistry.register("*", (HttpRequestHandler)new ProxyRequestHandler(this, this.logger, iHttpRequestEngine));
        this.httpService = new VegaHttpService((HttpProcessor)basicHttpProcessor, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory(), (HttpRequestHandlerResolver)httpRequestHandlerRegistry, this.params, sSLContextRepository);
        this.connectionList = new ArrayList<ConnectionTask>();
    }

    public IHttpProxyListenerConfig getConfig() {
        return this.config;
    }

    public IHttpRequestEngine getRequestEngine() {
        return this.requestEngine;
    }

    public void start() {
        this.executor = Executors.newCachedThreadPool();
        try {
            this.logger.info("Listening on " + this.config.getListenerAddress());
            this.serverSocket = new ServerSocket(this.config.getPort(), this.config.getBacklog(), this.config.getInetAddress());
            this.proxyThread = new Thread(this.createProxyLoopRunnable());
            this.proxyThread.start();
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "IO error creating listening socket on " + this.config.getListenerAddress() + ": " + iOException.getMessage(), iOException);
        }
    }

    private Runnable createProxyLoopRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                HttpProxyListener.this.proxyAcceptLoop();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyAcceptLoop() {
        Object object;
        while (!Thread.interrupted()) {
            try {
                object = this.serverSocket.accept();
            }
            catch (IOException iOException) {
                if (Thread.interrupted()) break;
                this.logger.log(Level.WARNING, "IO error processing incoming connection: " + iOException.getMessage(), iOException);
                break;
            }
            this.logger.fine("Connection accepted from " + ((Socket)object).getRemoteSocketAddress());
            VegaHttpServerConnection object2 = new VegaHttpServerConnection(this.params);
            try {
                object2.bind((Socket)object, this.params);
            }
            catch (IOException iOException) {
                this.logger.log(Level.WARNING, "Unexpected error: " + iOException.getMessage(), iOException);
                continue;
            }
            ConnectionTask connectionTask = new ConnectionTask(this.httpService, object2, this);
            List<ConnectionTask> list = this.connectionList;
            synchronized (list) {
                this.connectionList.add(connectionTask);
            }
            this.executor.execute(connectionTask);
        }
        object = this.connectionList;
        synchronized (object) {
            for (ConnectionTask connectionTask : this.connectionList) {
                connectionTask.shutdown();
            }
        }
        this.executor.shutdownNow();
    }

    public void stop() {
        this.proxyThread.interrupt();
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "Unexpected exception closing server socket: " + iOException.getMessage(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventHandler(IHttpInterceptProxyEventHandler iHttpInterceptProxyEventHandler) {
        List<IHttpInterceptProxyEventHandler> list = this.eventHandlers;
        synchronized (list) {
            this.eventHandlers.add(iHttpInterceptProxyEventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEventHandler(IHttpInterceptProxyEventHandler iHttpInterceptProxyEventHandler) {
        List<IHttpInterceptProxyEventHandler> list = this.eventHandlers;
        synchronized (list) {
            this.eventHandlers.remove(iHttpInterceptProxyEventHandler);
        }
    }

    public boolean handleTransaction(ProxyTransaction proxyTransaction) throws InterruptedException {
        if (!proxyTransaction.hasResponse()) {
            this.transactionManipulator.process((HttpRequest)proxyTransaction.getRequest());
        } else {
            this.transactionManipulator.process(proxyTransaction.getResponse().getRawResponse());
        }
        boolean bl = this.interceptor.handleTransaction(proxyTransaction);
        if (bl) {
            proxyTransaction.await();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeRequest(ProxyTransaction proxyTransaction) {
        List<IHttpInterceptProxyEventHandler> list = this.eventHandlers;
        synchronized (list) {
            for (IHttpInterceptProxyEventHandler iHttpInterceptProxyEventHandler : this.eventHandlers) {
                iHttpInterceptProxyEventHandler.handleRequest((IProxyTransaction)proxyTransaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClose(ConnectionTask connectionTask) {
        List<ConnectionTask> list = this.connectionList;
        synchronized (list) {
            this.connectionList.remove(connectionTask);
        }
    }
}

