/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.events.CancellableObjectEventArgs;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.NamedEventListenerManager;
import com.subgraph.vega.api.model.conditions.ConditionSetChanged;
import com.subgraph.vega.api.model.conditions.IHttpConditionManager;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.internal.model.conditions.ConditionHeader;
import com.subgraph.vega.internal.model.conditions.ConditionHostname;
import com.subgraph.vega.internal.model.conditions.ConditionPath;
import com.subgraph.vega.internal.model.conditions.ConditionRequestId;
import com.subgraph.vega.internal.model.conditions.ConditionRequestMethod;
import com.subgraph.vega.internal.model.conditions.ConditionResponseLength;
import com.subgraph.vega.internal.model.conditions.ConditionResponseStatusCode;
import com.subgraph.vega.internal.model.conditions.HttpConditionSet;
import com.subgraph.vega.internal.model.conditions.HttpConditionSetMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HttpConditionManager
implements IHttpConditionManager {
    private final ObjectContainer database;
    private final List<IHttpConditionType> conditionTypes;
    private final NamedEventListenerManager conditionSetChangedManager;

    public HttpConditionManager(ObjectContainer objectContainer, NamedEventListenerManager namedEventListenerManager) {
        this.database = objectContainer;
        this.conditionTypes = this.createConditionTypes();
        this.conditionSetChangedManager = namedEventListenerManager;
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer((ObjectContainer)objectContainer);
        eventRegistry.activating().addListener((EventListener4)new EventListener4<CancellableObjectEventArgs>(){

            public void onEvent(Event4<CancellableObjectEventArgs> event4, CancellableObjectEventArgs cancellableObjectEventArgs) {
                Object object = cancellableObjectEventArgs.object();
                if (object instanceof HttpConditionSet) {
                    ((HttpConditionSet)object).setConditionManager(HttpConditionManager.this);
                } else if (object instanceof HttpConditionSetMap) {
                    ((HttpConditionSetMap)object).setConditionManager(HttpConditionManager.this);
                }
            }
        });
        this.notifyAllChanged();
    }

    private List<IHttpConditionType> createConditionTypes() {
        ArrayList<IHttpConditionType> arrayList = new ArrayList<IHttpConditionType>();
        arrayList.add(ConditionHostname.getConditionType());
        arrayList.add(ConditionRequestMethod.getConditionType());
        arrayList.add(ConditionHeader.getRequestConditionType());
        arrayList.add(ConditionPath.getConditionType());
        arrayList.add(ConditionHeader.getResponseConditionType());
        arrayList.add(ConditionResponseLength.getConditionType());
        arrayList.add(ConditionResponseStatusCode.getConditionType());
        arrayList.add(ConditionRequestId.getConditionType());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClosed() {
        NamedEventListenerManager namedEventListenerManager = this.conditionSetChangedManager;
        synchronized (namedEventListenerManager) {
            this.conditionSetChangedManager.fireAllKeys((IEvent)new ConditionSetChanged(null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllChanged() {
        NamedEventListenerManager namedEventListenerManager = this.conditionSetChangedManager;
        synchronized (namedEventListenerManager) {
            for (String string : this.conditionSetChangedManager.getAllKeys()) {
                IHttpConditionSet iHttpConditionSet = this.getConditionSet(string);
                this.conditionSetChangedManager.fireEvent(string, (IEvent)new ConditionSetChanged(iHttpConditionSet));
            }
        }
    }

    void notifyConditionSetChanged(IHttpConditionSet iHttpConditionSet) {
        this.conditionSetChangedManager.fireEvent(iHttpConditionSet.getName(), (IEvent)new ConditionSetChanged(iHttpConditionSet));
    }

    public IHttpConditionSet getConditionSet(String string) {
        return this.getConditionSetMap().getConditionSet(string);
    }

    public IHttpConditionSet getConditionSetCopy(String string) {
        return this.getConditionSetMap().getConditionSetCopy(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConditionSet(String string, IHttpConditionSet iHttpConditionSet) {
        NamedEventListenerManager namedEventListenerManager = this.conditionSetChangedManager;
        synchronized (namedEventListenerManager) {
            this.getConditionSetMap().saveConditionSet(string, iHttpConditionSet);
            this.conditionSetChangedManager.fireEvent(string, (IEvent)new ConditionSetChanged(iHttpConditionSet));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpConditionSetMap getConditionSetMap() {
        HttpConditionManager httpConditionManager = this;
        synchronized (httpConditionManager) {
            ObjectSet objectSet = this.database.query(HttpConditionSetMap.class);
            if (objectSet.size() == 1) {
                return (HttpConditionSetMap)objectSet.get(0);
            }
            if (objectSet.size() > 1) {
                throw new IllegalStateException("Duplicate HttpConditionSetMap records in database");
            }
            HttpConditionSetMap httpConditionSetMap = new HttpConditionSetMap(this);
            this.database.store((Object)httpConditionSetMap);
            return httpConditionSetMap;
        }
    }

    public List<IHttpConditionType> getConditionTypes() {
        return this.getConditionTypes(false);
    }

    public List<IHttpConditionType> getConditionTypes(boolean bl) {
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<IHttpConditionType>(this.conditionTypes));
        }
        ArrayList<IHttpConditionType> arrayList = new ArrayList<IHttpConditionType>();
        for (IHttpConditionType iHttpConditionType : this.conditionTypes) {
            if (iHttpConditionType.isInternal()) continue;
            arrayList.add(iHttpConditionType);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public IHttpConditionType getConditionTypeByName(String string) {
        for (IHttpConditionType iHttpConditionType : this.getConditionTypes(true)) {
            if (!iHttpConditionType.getName().equals(string)) continue;
            return iHttpConditionType;
        }
        return null;
    }
}

