/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions;

import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.internal.model.conditions.AbstractCondition;
import com.subgraph.vega.internal.model.conditions.ConditionType;
import com.subgraph.vega.internal.model.conditions.match.StringMatchActionSet;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class ConditionRequestMethod
extends AbstractCondition {
    private static transient IHttpConditionType conditionType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IHttpConditionType getConditionType() {
        Class<ConditionRequestMethod> clazz = ConditionRequestMethod.class;
        synchronized (ConditionRequestMethod.class) {
            if (conditionType == null) {
                conditionType = ConditionRequestMethod.createType();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return conditionType;
        }
    }

    private static IHttpConditionType createType() {
        return new ConditionType("request method", new StringMatchActionSet()){

            public IHttpCondition createConditionInstance(IHttpConditionMatchAction iHttpConditionMatchAction) {
                return new ConditionRequestMethod(iHttpConditionMatchAction);
            }
        };
    }

    protected ConditionRequestMethod(IHttpConditionMatchAction iHttpConditionMatchAction) {
        super(iHttpConditionMatchAction);
    }

    public boolean matches(HttpRequest httpRequest) {
        if (httpRequest == null) {
            return false;
        }
        String string = httpRequest.getRequestLine().getMethod();
        return this.matchesString(string);
    }

    public boolean matches(HttpResponse httpResponse) {
        return false;
    }

    public boolean matches(HttpRequest httpRequest, HttpResponse httpResponse) {
        return this.matches(httpRequest);
    }

    public IHttpConditionType getType() {
        return ConditionRequestMethod.getConditionType();
    }

    @Override
    public Constraint filterRequestLogQuery(Query query) {
        return this.constrainQuery(query.descend("requestMethod"));
    }
}

