/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions;

import com.db4o.activation.ActivationPurpose;
import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.internal.model.conditions.AbstractCondition;
import com.subgraph.vega.internal.model.conditions.ConditionType;
import com.subgraph.vega.internal.model.conditions.match.StringMatchActionSet;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class ConditionHeader
extends AbstractCondition {
    private static transient IHttpConditionType requestConditionType;
    private static transient IHttpConditionType responseConditionType;
    private final boolean matchRequestHeader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IHttpConditionType getRequestConditionType() {
        Class<ConditionHeader> clazz = ConditionHeader.class;
        synchronized (ConditionHeader.class) {
            if (requestConditionType == null) {
                ConditionHeader.createTypes();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return requestConditionType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IHttpConditionType getResponseConditionType() {
        Class<ConditionHeader> clazz = ConditionHeader.class;
        synchronized (ConditionHeader.class) {
            if (responseConditionType == null) {
                ConditionHeader.createTypes();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return responseConditionType;
        }
    }

    private static void createTypes() {
        requestConditionType = ConditionHeader.createType("request header", true);
        responseConditionType = ConditionHeader.createType("response header", false);
    }

    private static IHttpConditionType createType(String string, final boolean bl) {
        return new ConditionType(string, new StringMatchActionSet()){

            public IHttpCondition createConditionInstance(IHttpConditionMatchAction iHttpConditionMatchAction) {
                return new ConditionHeader(bl, iHttpConditionMatchAction);
            }
        };
    }

    ConditionHeader(boolean bl, IHttpConditionMatchAction iHttpConditionMatchAction) {
        super(iHttpConditionMatchAction);
        this.matchRequestHeader = bl;
    }

    public boolean matches(HttpRequest httpRequest) {
        this.activate(ActivationPurpose.READ);
        if (this.matchRequestHeader) {
            return this.matchesString(this.headersToString((HttpMessage)httpRequest));
        }
        return false;
    }

    public boolean matches(HttpResponse httpResponse) {
        this.activate(ActivationPurpose.READ);
        if (!this.matchRequestHeader) {
            return this.matchesString(this.headersToString((HttpMessage)httpResponse));
        }
        return false;
    }

    private String headersToString(HttpMessage httpMessage) {
        if (httpMessage == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Header[] headerArray = httpMessage.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            stringBuilder.append(header.getName());
            stringBuilder.append(": ");
            stringBuilder.append(header.getValue());
            stringBuilder.append("\r\n");
            ++n2;
        }
        return stringBuilder.toString();
    }

    public boolean matches(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.activate(ActivationPurpose.READ);
        if (this.matchRequestHeader) {
            return this.matchesString(this.headersToString((HttpMessage)httpRequest));
        }
        return this.matchesString(this.headersToString((HttpMessage)httpResponse));
    }

    public IHttpConditionType getType() {
        this.activate(ActivationPurpose.READ);
        if (this.matchRequestHeader) {
            return ConditionHeader.getRequestConditionType();
        }
        return ConditionHeader.getResponseConditionType();
    }

    @Override
    public Constraint filterRequestLogQuery(Query query) {
        this.activate(ActivationPurpose.READ);
        if (this.matchRequestHeader) {
            return this.constrainQuery(query.descend("requestHeaders"));
        }
        return this.constrainQuery(query.descend("responseHeaders"));
    }
}

