/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.highlights;

import com.subgraph.vega.ui.httpeditor.highlights.MatchingRegions;
import com.subgraph.vega.ui.httpeditor.highlights.RegionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.graphics.Color;

public class MatchHighlighter
implements ITextInputListener {
    private final ProjectionViewer viewer;
    private final boolean isDisplaySingleMatch;
    private final MatchingRegions matchingRegions;
    private RegionInfo currentRegion;
    private boolean areAnnotationsAdded;
    private boolean isActive;

    public MatchHighlighter(ProjectionViewer projectionViewer, Color color, String string, boolean bl) {
        this.viewer = projectionViewer;
        this.isDisplaySingleMatch = bl;
        this.matchingRegions = new MatchingRegions(string);
        this.configureViewer((SourceViewer)projectionViewer, color, string);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getMatchCount() {
        return this.matchingRegions.getMatchCount();
    }

    public int getCurrentIndex() {
        return this.matchingRegions.getCurrentIndex();
    }

    public void displayFirstMatch() {
        if (this.matchingRegions.getMatchCount() == 0) {
            return;
        }
        this.maybeDisplayAllAnnotations();
        this.maybeHideAnnotation();
        this.currentRegion = this.matchingRegions.getFirstRegion();
        this.maybeDisplayAnnotation();
        this.revealDocumentRegion(this.currentRegion.getRegion());
    }

    public void displayNextMatch() {
        if (!this.matchingRegions.hasNext()) {
            return;
        }
        this.maybeHideAnnotation();
        this.currentRegion = this.matchingRegions.getNextRegion();
        this.maybeDisplayAnnotation();
        this.revealDocumentRegion(this.currentRegion.getRegion());
    }

    public void displayPreviousMatch() {
        if (!this.matchingRegions.hasPrevious()) {
            return;
        }
        this.maybeHideAnnotation();
        this.currentRegion = this.matchingRegions.getPreviousRegion();
        this.maybeDisplayAnnotation();
        this.revealDocumentRegion(this.currentRegion.getRegion());
    }

    public void clearMatches() {
        for (RegionInfo regionInfo : this.matchingRegions.getAllRegions()) {
            regionInfo.removeHighlight((SourceViewer)this.viewer);
        }
        this.matchingRegions.reset();
        this.currentRegion = null;
        this.areAnnotationsAdded = false;
        this.isActive = false;
    }

    public void searchMatches(String string, boolean bl, boolean bl2) {
        this.matchingRegions.addRegions(this.findAllMatches(string, bl, bl2));
        this.isActive = true;
    }

    public boolean hasNextMatch() {
        return this.matchingRegions.hasNext();
    }

    public boolean hasPreviousMatch() {
        return this.matchingRegions.hasPrevious();
    }

    private void maybeDisplayAllAnnotations() {
        if (!this.isDisplaySingleMatch && !this.areAnnotationsAdded) {
            for (RegionInfo regionInfo : this.matchingRegions.getAllRegions()) {
                regionInfo.displayHighlight((SourceViewer)this.viewer);
            }
            this.areAnnotationsAdded = true;
        }
    }

    private void maybeHideAnnotation() {
        if (this.isDisplaySingleMatch && this.currentRegion != null) {
            this.currentRegion.removeHighlight((SourceViewer)this.viewer);
        }
    }

    private void maybeDisplayAnnotation() {
        if (this.isDisplaySingleMatch && this.currentRegion != null) {
            this.currentRegion.displayHighlight((SourceViewer)this.viewer);
        }
    }

    private void revealDocumentRegion(IRegion iRegion) {
        this.viewer.revealRange(iRegion.getOffset(), iRegion.getLength());
    }

    private void configureViewer(SourceViewer sourceViewer, Color color, String string) {
        sourceViewer.addTextInputListener((ITextInputListener)this);
        this.attachHighlightPainter(sourceViewer, color, string);
    }

    private void attachHighlightPainter(SourceViewer sourceViewer, Color color, String string) {
        AnnotationPainter annotationPainter = new AnnotationPainter((ISourceViewer)sourceViewer, this.createAnnotationAccess());
        annotationPainter.addHighlightAnnotationType((Object)string);
        annotationPainter.setAnnotationTypeColor((Object)string, color);
        sourceViewer.addPainter((IPainter)annotationPainter);
        sourceViewer.addTextPresentationListener((ITextPresentationListener)annotationPainter);
    }

    private IAnnotationAccess createAnnotationAccess() {
        return new IAnnotationAccess(){

            public boolean isTemporary(Annotation annotation) {
                return true;
            }

            public boolean isMultiLine(Annotation annotation) {
                return true;
            }

            public Object getType(Annotation annotation) {
                return annotation.getType();
            }
        };
    }

    private List<IRegion> findAllMatches(String string, boolean bl, boolean bl2) {
        IDocument iDocument = this.viewer.getDocument();
        if (string.isEmpty() || iDocument == null) {
            return Collections.emptyList();
        }
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(iDocument);
        ArrayList<IRegion> arrayList = new ArrayList<IRegion>();
        int n = 0;
        while (n < iDocument.getLength()) {
            try {
                IRegion iRegion = findReplaceDocumentAdapter.find(n, string, true, bl2, false, bl);
                if (iRegion == null) {
                    return arrayList;
                }
                arrayList.add(iRegion);
                n = iRegion.getOffset() + iRegion.getLength();
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException("Bad location while performing search");
            }
        }
        return arrayList;
    }

    public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
        this.clearMatches();
    }

    public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
    }
}

