/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor;

import com.subgraph.vega.ui.hexeditor.HexEditControl;
import com.subgraph.vega.ui.httpeditor.HttpMessageDocument;
import com.subgraph.vega.ui.httpeditor.HttpMessageEntity;
import com.subgraph.vega.ui.httpeditor.annotations.AnnotationPainter;
import com.subgraph.vega.ui.httpeditor.annotations.ImageAnnotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BinaryEntityManager {
    private final AnnotationPainter annotationPainter;
    private final SourceViewer viewer;
    private final SashForm sashForm;
    private final Composite root;
    private final HexEditControl hexEditor;
    private HttpMessageDocument activeDocument;
    private ImageAnnotation imageAnnotation;
    private boolean displayImages = true;
    private boolean displayImagesAsHex = false;

    BinaryEntityManager(SourceViewer sourceViewer, SashForm sashForm, Composite composite) {
        this.viewer = sourceViewer;
        this.annotationPainter = new AnnotationPainter(sourceViewer);
        this.sashForm = sashForm;
        this.root = composite;
        this.hexEditor = new HexEditControl((Composite)this.sashForm);
        this.sashForm.setMaximizedControl((Control)composite);
    }

    void dispose() {
        this.annotationPainter.dispose();
    }

    void clear() {
        this.sashForm.setMaximizedControl((Control)this.root);
        if (this.imageAnnotation != null) {
            this.removeImageAnnotation();
        }
        this.hexEditor.setInput(new byte[0]);
        this.activeDocument = null;
    }

    private boolean isImageEntity() {
        return this.activeDocument != null && this.activeDocument.getMessageEntity().isImageEntity();
    }

    boolean isContentDirty() {
        return this.hexEditor.isContentDirty();
    }

    byte[] getContent() {
        return this.hexEditor.getContent();
    }

    void displayImagesAsHex(boolean bl) {
        this.displayImagesAsHex = bl;
        this.displayImageForState();
    }

    void displayImages(boolean bl) {
        this.displayImages = bl;
        this.displayImageForState();
    }

    void displayImageForState() {
        if (!this.isImageEntity()) {
            this.sashForm.setMaximizedControl((Control)this.root);
            return;
        }
        if (this.displayImages) {
            if (this.displayImagesAsHex) {
                if (this.imageAnnotation != null) {
                    this.removeImageAnnotation();
                }
                this.sashForm.setMaximizedControl(null);
            } else {
                if (this.isImageEntity()) {
                    this.addImageAnnotation(this.activeDocument.getDocument(), this.activeDocument.getMessageEntity().getImageData());
                }
                this.sashForm.setMaximizedControl((Control)this.root);
            }
        } else {
            this.sashForm.setMaximizedControl((Control)this.root);
            this.removeImageAnnotation();
        }
    }

    void displayNewDocument(HttpMessageDocument httpMessageDocument) {
        this.clear();
        this.activeDocument = httpMessageDocument;
        HttpMessageEntity httpMessageEntity = httpMessageDocument.getMessageEntity();
        if (!httpMessageEntity.isBinaryEntity() && !httpMessageEntity.isImageEntity()) {
            return;
        }
        if (httpMessageEntity.isImageEntity()) {
            this.hexEditor.setInput(httpMessageEntity.getBinaryData());
            this.displayImageForState();
        } else {
            this.hexEditor.setInput(httpMessageEntity.getBinaryData());
            this.sashForm.setMaximizedControl(null);
        }
    }

    private void addImageAnnotation(IDocument iDocument, ImageData imageData) {
        if (this.imageAnnotation != null) {
            this.removeImageAnnotation();
        }
        Image image = new Image((Device)this.sashForm.getDisplay(), imageData);
        this.imageAnnotation = new ImageAnnotation(image);
        Position position = this.padDocumentForImage(iDocument, this.imageAnnotation.getPaddingString((TextViewer)this.viewer));
        this.annotationPainter.addAnnotation(this.imageAnnotation, position);
    }

    private void removeImageAnnotation() {
        if (this.imageAnnotation == null) {
            return;
        }
        Position position = this.annotationPainter.getPosition(this.imageAnnotation);
        this.annotationPainter.removeAnnotation(this.imageAnnotation);
        this.activeDocument.getDocument().removePosition(position);
        try {
            this.activeDocument.getDocument().replace(position.offset, position.length, "");
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Internal Error: " + badLocationException.getMessage(), badLocationException);
        }
        this.imageAnnotation = null;
    }

    private Position padDocumentForImage(IDocument iDocument, String string) {
        Position position = new Position(iDocument.getLength(), string.length());
        try {
            iDocument.replace(iDocument.getLength(), 0, string);
            iDocument.addPosition(position);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Internal Error: " + badLocationException.getMessage(), badLocationException);
        }
        return position;
    }
}

