/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.subgraph.vega.internal.sslprobe.CertificateAnalyzer;
import com.subgraph.vega.internal.sslprobe.CipherSuites;
import com.subgraph.vega.internal.sslprobe.SSLServerScanResult;
import com.subgraph.vega.internal.sslprobe.SSLv2Probe;
import com.subgraph.vega.internal.sslprobe.TLSCipherProbeTask;
import com.subgraph.vega.internal.sslprobe.TLSCipherSpec;
import com.subgraph.vega.internal.sslprobe.TLSProbeResult;
import com.subgraph.vega.internal.sslprobe.TLSServerCipherPreferenceProbe;
import com.subgraph.vega.internal.sslprobe.TLSVersionProbe;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class SSLScanTaskManager {
    private static final Logger logger = Logger.getLogger(SSLScanTaskManager.class.getName());
    private final ExecutorService executor;
    private static int CIPHERS_PER_REQUEST = 300;

    public SSLScanTaskManager(ExecutorService executorService) {
        this.executor = executorService;
    }

    public void shutdown() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(120L, TimeUnit.SECONDS);
    }

    public SSLServerScanResult scanServer(String string, int n) throws InterruptedException {
        logger.info("Starting scan of " + string + ":" + n);
        SSLServerScanResult sSLServerScanResult = new SSLServerScanResult(string, n);
        if (this.probeServerSupportedTLSCiphers(sSLServerScanResult)) {
            this.probeSupportedVersions(sSLServerScanResult);
            this.probeCipherPreference(sSLServerScanResult);
        }
        this.probeSSLv2Support(sSLServerScanResult);
        sSLServerScanResult.waitForOutstandingProbes();
        return sSLServerScanResult;
    }

    private void probeSSLv2Support(SSLServerScanResult sSLServerScanResult) {
        this.executor.execute(new SSLv2Probe(sSLServerScanResult));
    }

    private boolean probeServerSupportedTLSCiphers(SSLServerScanResult sSLServerScanResult) {
        ExecutorCompletionService<TLSProbeResult> executorCompletionService = new ExecutorCompletionService<TLSProbeResult>(this.executor);
        int n = this.sendInitialCipherProbes(executorCompletionService, sSLServerScanResult);
        while (n > 0) {
            TLSProbeResult tLSProbeResult = this.getNextCompletedCipherProbe(executorCompletionService);
            if (tLSProbeResult == null) {
                return false;
            }
            if (tLSProbeResult.isError()) {
                sSLServerScanResult.setTLSProbeFailure(tLSProbeResult.getErrorMessage());
                return false;
            }
            if (tLSProbeResult == null || tLSProbeResult.isError()) {
                return false;
            }
            --n;
            if (!this.processTLSCipherProbeResult(executorCompletionService, sSLServerScanResult, tLSProbeResult)) continue;
            ++n;
        }
        return true;
    }

    private int sendInitialCipherProbes(CompletionService<TLSProbeResult> completionService, SSLServerScanResult sSLServerScanResult) {
        int n = 0;
        for (List<TLSCipherSpec> list : CipherSuites.paritionTLSCiphers(CIPHERS_PER_REQUEST)) {
            ++n;
            TLSCipherProbeTask tLSCipherProbeTask = new TLSCipherProbeTask(sSLServerScanResult, list);
            completionService.submit(tLSCipherProbeTask);
        }
        return n;
    }

    private TLSProbeResult getNextCompletedCipherProbe(CompletionService<TLSProbeResult> completionService) {
        try {
            Future<TLSProbeResult> future = completionService.take();
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException executionException) {
            logger.warning("Unexpected exception encountered sending TLS cipher probe: " + executionException.getCause());
            executionException.printStackTrace();
            return null;
        }
    }

    private boolean processTLSCipherProbeResult(CompletionService<TLSProbeResult> completionService, SSLServerScanResult sSLServerScanResult, TLSProbeResult tLSProbeResult) {
        if (tLSProbeResult.getAcceptedCipher() == null) {
            return false;
        }
        sSLServerScanResult.addServerTLSCipher(tLSProbeResult.getAcceptedCipher());
        for (CertificateAnalyzer object2 : tLSProbeResult.getServerCertificates()) {
            sSLServerScanResult.addServerCertificate(object2);
        }
        if (tLSProbeResult.getTLSCompressionSupport()) {
            sSLServerScanResult.setFlag(SSLServerScanResult.Flag.TLS_COMPRESSION);
        }
        if (tLSProbeResult.getRejectedCiphers().size() == 0) {
            return false;
        }
        TLSCipherProbeTask tLSCipherProbeTask = new TLSCipherProbeTask(sSLServerScanResult, tLSProbeResult.getRejectedCiphers());
        completionService.submit(tLSCipherProbeTask);
        return true;
    }

    private void probeSupportedVersions(SSLServerScanResult sSLServerScanResult) {
        List<TLSCipherSpec> list = sSLServerScanResult.getServerTLSCiphers();
        if (!list.isEmpty()) {
            for (Runnable runnable : TLSVersionProbe.getVersionProbes(sSLServerScanResult)) {
                this.executor.execute(runnable);
            }
        }
    }

    private void probeCipherPreference(SSLServerScanResult sSLServerScanResult) {
        this.executor.execute(new TLSServerCipherPreferenceProbe(sSLServerScanResult));
    }
}

