/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.subgraph.vega.internal.sslprobe.SSLv2CipherSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class SSL2Protocol {
    public static final int SSLV2_CLIENT_HELLO = 1;
    public static final int SSLV2_SERVER_HELLO = 4;
    private static final int SSLV2_HEADER_LENGTH = 2;
    private static final int SSLV2_VERSION = 2;
    private static final int SSLV2_CHALLENGE_LENGTH = 16;
    private static final int SSLV2_CLIENT_HELLO_BASE_LENGTH = 25;
    private final InputStream input;
    private final OutputStream output;

    public SSL2Protocol(InputStream inputStream, OutputStream outputStream) {
        this.input = inputStream;
        this.output = outputStream;
    }

    public ByteBuffer getNextHandshakeMessage() throws IOException {
        int n = this.readRecordLength();
        if (n == -1) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        if (!this.readAll(byteBuffer)) {
            return null;
        }
        return byteBuffer;
    }

    private int readRecordLength() throws IOException {
        byte[] byArray = new byte[2];
        if (this.input.read(byArray, 0, byArray.length) != byArray.length) {
            return -1;
        }
        return (byArray[0] & 0x7F) << 8 | byArray[1] & 0xFF;
    }

    private boolean readAll(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            int n = this.input.read(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
            if (n == -1) {
                return false;
            }
            byteBuffer.position(byteBuffer.position() + n);
        }
        byteBuffer.rewind();
        return true;
    }

    public void sendClientHello(List<SSLv2CipherSpec> list) throws IOException {
        ByteBuffer byteBuffer = this.createClientHello(list);
        this.writeAll(byteBuffer);
    }

    private ByteBuffer createClientHello(List<SSLv2CipherSpec> list) {
        int n = 27 + 3 * list.size();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.putShort((short)(0x8000 | n - 2));
        byteBuffer.put((byte)1);
        byteBuffer.putShort((short)2);
        byteBuffer.putShort((short)(list.size() * 3));
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)16);
        for (SSLv2CipherSpec object2 : list) {
            byteBuffer.put(object2.getNumber());
        }
        byte[] byArray = new byte[16];
        Arrays.fill(byArray, (byte)1);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }

    private void writeAll(ByteBuffer byteBuffer) throws IOException {
        this.output.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
        byteBuffer.position(byteBuffer.position() + byteBuffer.remaining());
        this.output.flush();
    }
}

