/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.state;

import com.subgraph.vega.api.http.requests.IPageFingerprint;
import com.subgraph.vega.api.scanner.IPathState;
import java.util.ArrayList;
import java.util.List;

public class PathState404 {
    private static final int MAX_404_SIGS = 4;
    private final IPathState pathState;
    private final List<IPageFingerprint> page404Fingerprints = new ArrayList<IPageFingerprint>();
    private boolean skip404;

    PathState404(IPathState iPathState) {
        this.pathState = iPathState;
    }

    void setSkip404() {
        this.skip404 = true;
    }

    boolean getSkip404() {
        return this.skip404;
    }

    public synchronized boolean hasMaximum404Fingerprints() {
        return this.page404Fingerprints.size() == 4;
    }

    public synchronized boolean add404Fingerprint(IPageFingerprint iPageFingerprint) {
        if (this.hasMaximum404Fingerprints()) {
            return false;
        }
        if (!this.has404FingerprintMatching(iPageFingerprint)) {
            this.page404Fingerprints.add(iPageFingerprint);
        }
        return true;
    }

    public synchronized boolean has404Fingerprints() {
        return !this.page404Fingerprints.isEmpty();
    }

    public IPathState get404Parent() {
        IPathState iPathState = this.pathState.getParentState();
        if (iPathState != null && iPathState.has404Fingerprints()) {
            return iPathState;
        }
        return null;
    }

    public synchronized boolean has404FingerprintMatching(IPageFingerprint iPageFingerprint) {
        if (iPageFingerprint == null) {
            return false;
        }
        for (IPageFingerprint iPageFingerprint2 : this.page404Fingerprints) {
            if (!iPageFingerprint2.isSame(iPageFingerprint)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParent404Fingerprint(IPageFingerprint iPageFingerprint) {
        IPathState iPathState = this.get404Parent();
        return iPathState != null && iPathState.has404FingerprintMatching(iPageFingerprint);
    }

    public synchronized void clear404Fingerprints() {
        this.page404Fingerprints.clear();
    }

    public void dumpFingerprints() {
        for (IPageFingerprint iPageFingerprint : this.page404Fingerprints) {
            System.out.println(iPageFingerprint);
        }
    }
}

