/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.requests;

import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.impl.scanner.requests.IRequestBuilder;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class AbstractRequestBuilder
implements IRequestBuilder {
    protected final IHttpRequestEngine requestEngine;
    protected final IWebPath webPath;

    protected AbstractRequestBuilder(IHttpRequestEngine iHttpRequestEngine, IWebPath iWebPath) {
        this.requestEngine = iHttpRequestEngine;
        this.webPath = iWebPath;
    }

    protected HttpUriRequest createRequestForPath(String string) {
        return this.requestEngine.createGetRequest(this.webPath.getHttpHost(), string);
    }

    protected HttpUriRequest createPathRequest() {
        return this.createRequestForPath(this.getBasePath());
    }

    protected HttpUriRequest createRequestFromQuery(String string) {
        String string2 = String.valueOf(this.getBasePath()) + "?" + string;
        return this.createRequestForPath(string2);
    }

    protected String getBasePath() {
        switch (this.webPath.getPathType()) {
            case PATH_DIRECTORY: {
                return this.maybeAddTrailingSlash(this.webPath.getFullPath());
            }
            case PATH_PATHINFO: {
                return this.maybeRemoveTrailingSlash(this.webPath.getFullPath());
            }
        }
        return this.webPath.getFullPath();
    }

    private String maybeAddTrailingSlash(String string) {
        if (string.endsWith("/")) {
            return string;
        }
        return String.valueOf(string) + "/";
    }

    private String maybeRemoveTrailingSlash(String string) {
        if (!string.endsWith("/")) {
            return string;
        }
        String string2 = string;
        while (string2.length() > 0 && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }
}

