/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.handlers;

import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.scanner.IPathState;
import com.subgraph.vega.api.scanner.modules.IBasicModuleScript;
import com.subgraph.vega.impl.scanner.handlers.PageVariabilityCheck;
import com.subgraph.vega.impl.scanner.handlers.PutChecks;
import com.subgraph.vega.impl.scanner.state.PathState;

public class InjectionChecks {
    private final PutChecks putChecks = new PutChecks(this);
    private final PageVariabilityCheck pageVariabilityChecks = new PageVariabilityCheck(this);

    public void initialize(IPathState iPathState) {
        iPathState.unlockChildren();
        if (iPathState.getPath().getPathType() == IWebPath.PathType.PATH_DIRECTORY) {
            this.putChecks.initialize(iPathState);
        }
        if (iPathState.isParametric()) {
            this.launchInjectionModules(iPathState);
        } else {
            this.runPageVariabilityCheck(iPathState);
        }
    }

    public void runPageVariabilityCheck(IPathState iPathState) {
        if (iPathState.doInjectionChecks()) {
            this.pageVariabilityChecks.initialize(iPathState);
        } else {
            iPathState.setDone();
        }
    }

    public void launchInjectionModules(IPathState iPathState) {
        for (IBasicModuleScript iBasicModuleScript : iPathState.getInjectionModules()) {
            if (!iBasicModuleScript.isEnabled() || iPathState.getResponseVaries() && iBasicModuleScript.isDifferential()) continue;
            iBasicModuleScript.runScript(iPathState);
        }
        ((PathState)iPathState).setFinishOnNoRequests();
    }
}

