/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.html.dom;

import com.subgraph.vega.internal.html.dom.HTMLElementImpl;
import com.subgraph.vega.internal.html.dom.NodeImpl;
import com.subgraph.vega.internal.html.dom.NodeListImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;

public class HTMLCollectionImpl
implements HTMLCollection {
    private List<HTMLElementImpl> byIndex = new ArrayList<HTMLElementImpl>();
    private Map<String, HTMLElement> byId = new HashMap<String, HTMLElement>();
    private Map<String, HTMLElement> byName = new HashMap<String, HTMLElement>();

    HTMLCollectionImpl(List<HTMLElementImpl> list) {
        for (HTMLElementImpl hTMLElementImpl : list) {
            this.addElement(hTMLElementImpl);
        }
    }

    HTMLCollectionImpl(List<Element> list, Document document) {
        for (Element element : list) {
            HTMLElementImpl hTMLElementImpl = HTMLElementImpl.create(element, document);
            this.addElement(hTMLElementImpl);
        }
    }

    private void addElement(HTMLElementImpl hTMLElementImpl) {
        String string = hTMLElementImpl.getAttribute("id");
        String string2 = hTMLElementImpl.getAttribute("name");
        this.byIndex.add(hTMLElementImpl);
        if (string != null) {
            this.byId.put("id", hTMLElementImpl);
        }
        if (string2 != null) {
            this.byName.put("name", hTMLElementImpl);
        }
    }

    @Override
    public int getLength() {
        return this.byIndex.size();
    }

    @Override
    public Node item(int n) {
        if (n >= 0 && n < this.byIndex.size()) {
            return this.byIndex.get(n);
        }
        return null;
    }

    @Override
    public Node namedItem(String string) {
        if (this.byId.containsKey(string)) {
            return this.byId.get(string);
        }
        return this.byName.get(string);
    }

    NodeList toNodeList() {
        ArrayList<NodeImpl> arrayList = new ArrayList<NodeImpl>();
        arrayList.addAll(this.byIndex);
        return new NodeListImpl(arrayList);
    }
}

