/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.web.views;

import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.model.web.IWebEntity;
import com.subgraph.vega.api.model.web.IWebHost;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.IWebResponse;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ScopeFilter
extends ViewerFilter {
    private final IModel model;

    ScopeFilter(IModel iModel) {
        this.model = iModel;
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        ITargetScope iTargetScope = this.getActiveScope();
        if (iTargetScope == null) {
            return true;
        }
        if (object2 instanceof IWebEntity) {
            return this.isFiltered(iTargetScope, (IWebEntity)object2);
        }
        return true;
    }

    private boolean isFiltered(ITargetScope iTargetScope, IWebEntity iWebEntity) {
        if (iWebEntity instanceof IWebHost) {
            return this.isHostFiltered(iTargetScope, (IWebHost)iWebEntity);
        }
        if (iWebEntity instanceof IWebPath) {
            return this.isPathFiltered(iTargetScope, (IWebPath)iWebEntity);
        }
        if (iWebEntity instanceof IWebResponse) {
            return this.isPathFiltered(iTargetScope, ((IWebResponse)iWebEntity).getPathEntity());
        }
        return true;
    }

    private boolean isHostFiltered(ITargetScope iTargetScope, IWebHost iWebHost) {
        if (iTargetScope.filter(iWebHost.getUri())) {
            return true;
        }
        return this.isPathFiltered(iTargetScope, iWebHost.getRootPath());
    }

    private boolean isPathFiltered(ITargetScope iTargetScope, IWebPath iWebPath) {
        if (iTargetScope.filter(iWebPath.getUri())) {
            return true;
        }
        for (IWebPath iWebPath2 : iWebPath.getChildPaths()) {
            if (!this.isPathFiltered(iTargetScope, iWebPath2)) continue;
            return true;
        }
        return false;
    }

    private ITargetScope getActiveScope() {
        IWorkspace iWorkspace = this.model.getCurrentWorkspace();
        if (iWorkspace == null) {
            return null;
        }
        return iWorkspace.getTargetScopeManager().getActiveScope();
    }
}

