/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.http.requests.builder;

import com.subgraph.vega.api.http.requests.IHttpHeaderBuilder;
import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.http.requests.builder.HttpMessageBuilder;
import com.subgraph.vega.http.requests.custom.VegaHttpEntityEnclosingUriRequest;
import com.subgraph.vega.http.requests.custom.VegaHttpUriRequest;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpRequestBuilder
extends HttpMessageBuilder
implements IHttpRequestBuilder {
    private String scheme = "http";
    private String host = "";
    private int hostPort = 80;
    private String method = "";
    private String path = "";

    @Override
    public synchronized void clear() {
        super.clear();
        this.scheme = "http";
        this.host = "";
        this.hostPort = 80;
        this.method = "";
        this.path = "";
    }

    public synchronized void setFromRequest(IRequestLogRecord iRequestLogRecord) throws URISyntaxException {
        this.setFromRequest(iRequestLogRecord.getRequest());
        this.setFromHttpHost(iRequestLogRecord.getHttpHost());
    }

    public synchronized void setFromRequest(HttpRequest httpRequest) throws URISyntaxException {
        this.setParams(httpRequest.getParams().copy());
        if (httpRequest instanceof HttpUriRequest) {
            this.setSchemeAndHostFromUri(((HttpUriRequest)httpRequest).getURI());
        }
        this.setFromRequestLine(httpRequest.getRequestLine());
        this.setHeaders(httpRequest.getAllHeaders());
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            this.setEntity(((HttpEntityEnclosingRequest)httpRequest).getEntity());
        } else {
            this.setEntity(null);
        }
    }

    public synchronized void setFromRequestLine(RequestLine requestLine) throws URISyntaxException {
        this.method = requestLine.getMethod();
        this.path = requestLine.getUri();
        this.setProtocolVersion(requestLine.getProtocolVersion());
    }

    public synchronized void setFromUri(URI uRI) {
        this.setSchemeAndHostFromUri(uRI);
        this.setPathFromUri(uRI);
    }

    private void setSchemeAndHostFromUri(URI uRI) {
        HttpHost httpHost = URIUtils.extractHost((URI)uRI);
        if (httpHost == null) {
            return;
        }
        if (httpHost.getSchemeName() != null) {
            this.scheme = httpHost.getSchemeName();
            if (httpHost.getHostName() != null) {
                this.host = httpHost.getHostName();
                this.hostPort = httpHost.getPort();
                if (this.hostPort == -1) {
                    this.hostPort = this.getSchemeDefaultPort(this.scheme);
                }
            }
        }
    }

    private void setPathFromUri(URI uRI) {
        this.path = uRI.getRawPath();
        if (this.path != null) {
            if (this.path.length() == 0 || this.path.charAt(0) != '/') {
                this.path = String.valueOf('/') + this.path;
            }
        } else {
            this.path = "";
        }
        if (uRI.getRawQuery() != null) {
            this.path = String.valueOf(this.path) + '?' + uRI.getRawQuery();
        }
        if (uRI.getRawFragment() != null) {
            this.path = String.valueOf(this.path) + '#' + uRI.getRawFragment();
        }
    }

    public synchronized void setFromHttpHost(HttpHost httpHost) {
        this.scheme = httpHost.getSchemeName();
        if (this.scheme == null) {
            this.scheme = "http";
        }
        this.host = httpHost.getHostName();
        this.hostPort = httpHost.getPort();
        if (this.hostPort == -1) {
            this.hostPort = this.getSchemeDefaultPort(this.scheme);
        }
    }

    private int getSchemeDefaultPort(String string) {
        if (string.equals("https")) {
            return 443;
        }
        return 80;
    }

    private boolean isSchemeDefaultPort(String string, int n) {
        return string.equals("https") ? n == 443 : n == 80;
    }

    public synchronized void setScheme(String string) {
        this.scheme = string != null ? string.trim() : "http";
    }

    public synchronized String getScheme() {
        return this.scheme;
    }

    public synchronized void setHost(String string) {
        this.host = string != null ? string.trim() : null;
    }

    public synchronized String getHost() {
        return this.host;
    }

    public synchronized void setHostPort(int n) {
        this.hostPort = n != -1 ? n : 80;
    }

    public synchronized int getHostPort() {
        return this.hostPort;
    }

    public synchronized void setMethod(String string) {
        this.method = string != null ? string.trim() : null;
    }

    public synchronized String getMethod() {
        return this.method;
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized void setPath(String string) {
        if (string != null) {
            String string2 = string.trim();
            if (string2.length() == 0 || string2.charAt(0) != '/') {
                string2 = String.valueOf('/') + string2;
            }
            this.path = string2;
        } else {
            this.path = null;
        }
    }

    public synchronized String getRequestLine() {
        ProtocolVersion protocolVersion;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.method != null) {
            stringBuilder.append(this.method);
        }
        if (this.path != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.path);
        }
        if ((protocolVersion = this.getProtocolVersion()) != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(protocolVersion.toString());
        }
        return stringBuilder.toString();
    }

    public synchronized HttpUriRequest buildRequest(boolean bl) throws URISyntaxException {
        IHttpHeaderBuilder[] iHttpHeaderBuilderArray;
        ProtocolVersion protocolVersion;
        HttpUriRequest httpUriRequest = this.createRequest(this.buildHost());
        HttpParams httpParams = this.getParams();
        if (httpParams == null) {
            httpParams = new BasicHttpParams();
        }
        if ((protocolVersion = this.getProtocolVersion()) != null) {
            HttpProtocolParams.setVersion((HttpParams)httpUriRequest.getParams(), (ProtocolVersion)protocolVersion);
        }
        httpUriRequest.setParams(httpParams);
        if (bl) {
            this.setHeadersEntity();
        }
        IHttpHeaderBuilder[] iHttpHeaderBuilderArray2 = iHttpHeaderBuilderArray = this.getHeaders();
        int n = iHttpHeaderBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHttpHeaderBuilder iHttpHeaderBuilder = iHttpHeaderBuilderArray2[n2];
            httpUriRequest.addHeader(iHttpHeaderBuilder.buildHeader());
            ++n2;
        }
        return httpUriRequest;
    }

    private HttpHost buildHost() {
        if (this.host == null || this.host.length() == 0) {
            throw new IllegalArgumentException("Invalid host");
        }
        if (this.isSchemeDefaultPort(this.scheme, this.hostPort)) {
            return new HttpHost(this.host, -1, this.scheme);
        }
        return new HttpHost(this.host, this.hostPort, this.scheme);
    }

    private HttpUriRequest createRequest(HttpHost httpHost) {
        String string = this.path == null ? "" : this.path;
        HttpEntity httpEntity = this.getEntity();
        if (httpEntity != null) {
            return this.createEntityEnclosingRequest(httpHost, string, httpEntity);
        }
        return new VegaHttpUriRequest(httpHost, this.method, string);
    }

    private HttpUriRequest createEntityEnclosingRequest(HttpHost httpHost, String string, HttpEntity httpEntity) {
        VegaHttpEntityEnclosingUriRequest vegaHttpEntityEnclosingUriRequest = new VegaHttpEntityEnclosingUriRequest(httpHost, this.method, string);
        vegaHttpEntityEnclosingUriRequest.setEntity(httpEntity);
        return vegaHttpEntityEnclosingUriRequest;
    }
}

