/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.js;

import com.subgraph.vega.ui.httpeditor.Colors;
import com.subgraph.vega.ui.httpeditor.ITextEntityRenderer;
import com.subgraph.vega.ui.httpeditor.js.JavascriptScanner;
import com.subgraph.vega.ui.httpeditor.js.formatter.JavascriptFormatter;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class JavascriptTextEntityRenderer
implements ITextEntityRenderer {
    public static final String JS_DEFAULT_TYPE = "js_default";
    public static final String JS_MULTILINE_COMMENT = "js_multiline_comment";
    public static final String[] JS_PARTITION_TYPES = new String[]{"js_default", "js_multiline_comment"};
    private final JavascriptFormatter formatter = new JavascriptFormatter();

    @Override
    public List<String> getPartitionTypes() {
        return Arrays.asList(JS_PARTITION_TYPES);
    }

    @Override
    public boolean matchContentType(String string) {
        return string.contains("javascript") || string.contains("json");
    }

    @Override
    public void addPartitionScannerRules(List<IPredicateRule> list) {
        list.add((IPredicateRule)new EndOfLineRule("//", Token.UNDEFINED));
        list.add((IPredicateRule)new SingleLineRule("\"", "\"", Token.UNDEFINED, '\\'));
        list.add((IPredicateRule)new SingleLineRule("'", "'", Token.UNDEFINED, '\\'));
        list.add((IPredicateRule)new MultiLineRule("/*", "*/", (IToken)new Token((Object)JS_MULTILINE_COMMENT)));
    }

    @Override
    public void configurePresentationReconciler(PresentationReconciler presentationReconciler, Colors colors) {
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new JavascriptScanner(colors));
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, JS_DEFAULT_TYPE);
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, JS_DEFAULT_TYPE);
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colors.get(Colors.MULTI_LINE_COMMENT))));
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, JS_MULTILINE_COMMENT);
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, JS_MULTILINE_COMMENT);
    }

    @Override
    public String formatText(String string) {
        return this.formatter.format(string);
    }

    @Override
    public String getLineSplitChars() {
        return " ;";
    }

    @Override
    public String getDefaultPartitionType() {
        return JS_DEFAULT_TYPE;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute textAttribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)textAttribute));
        }
    }
}

