/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.internal.http.proxy.VegaHttpServerConnection;
import com.subgraph.vega.internal.http.proxy.ssl.SSLContextRepository;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpServerConnection;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.util.EncodingUtils;

public class VegaHttpService {
    private static final int DEFAULT_SSL_PORT = 443;
    private final HttpResponseFactory responseFactory;
    private final HttpProcessor processor;
    private final HttpService delegatedHttpService;
    private final SSLContextRepository sslContextRepository;
    private final boolean sslEnabled;

    public VegaHttpService(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HttpResponseFactory httpResponseFactory, HttpRequestHandlerResolver httpRequestHandlerResolver, HttpParams httpParams, SSLContextRepository sSLContextRepository) {
        this.delegatedHttpService = new HttpService(httpProcessor, connectionReuseStrategy, httpResponseFactory, httpRequestHandlerResolver, httpParams);
        this.sslContextRepository = sSLContextRepository;
        this.sslEnabled = sSLContextRepository != null;
        this.responseFactory = httpResponseFactory;
        this.processor = httpProcessor;
    }

    public void handleRequest(VegaHttpServerConnection vegaHttpServerConnection, HttpContext httpContext) throws IOException, HttpException {
        if (!this.sslEnabled) {
            this.delegatedHttpService.handleRequest((HttpServerConnection)vegaHttpServerConnection, httpContext);
            return;
        }
        HttpRequest httpRequest = vegaHttpServerConnection.peekRequestHeader();
        if (this.isCertificateDownload(httpRequest)) {
            vegaHttpServerConnection.dropCachedPeekRequest();
            this.sendCertificateDownloadResponse(vegaHttpServerConnection, httpContext);
        } else if (this.isConnectMethodRequest(httpRequest)) {
            vegaHttpServerConnection.dropCachedPeekRequest();
            this.handleConnect(vegaHttpServerConnection, httpRequest, httpContext);
        } else {
            this.delegatedHttpService.handleRequest((HttpServerConnection)vegaHttpServerConnection, httpContext);
        }
    }

    private void handleConnect(VegaHttpServerConnection vegaHttpServerConnection, HttpRequest httpRequest, HttpContext httpContext) throws IOException, HttpException {
        HttpHost httpHost = this.createHostForConnectUri(httpRequest.getRequestLine().getUri());
        SSLSocket sSLSocket = this.createSSLSocketForHost(httpHost, vegaHttpServerConnection.getSocket());
        this.sendResponseOk(vegaHttpServerConnection, httpContext);
        vegaHttpServerConnection.rebindWithSSL(sSLSocket, httpHost);
        try {
            sSLSocket.startHandshake();
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            vegaHttpServerConnection.close();
            return;
        }
        this.delegatedHttpService.handleRequest((HttpServerConnection)vegaHttpServerConnection, httpContext);
    }

    private HttpHost createHostForConnectUri(String string) {
        String[] stringArray = string.split(":");
        String string2 = stringArray[0].toLowerCase();
        int n = stringArray.length < 2 ? 443 : this.stringToSSLPort(stringArray[1]);
        return new HttpHost(string2, n, "https");
    }

    private int stringToSSLPort(String string) {
        if (string == null || string.isEmpty()) {
            return 443;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 443;
        }
    }

    private void sendCertificateDownloadResponse(VegaHttpServerConnection vegaHttpServerConnection, HttpContext httpContext) throws HttpException, IOException {
        String string = this.sslContextRepository.getCaCertificatePem();
        byte[] byArray = EncodingUtils.getAsciiBytes((String)string);
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(byArray);
        byteArrayEntity.setContentType("application/x-x509-ca-cert; charset=US-ASCII");
        this.sendResponseOk(vegaHttpServerConnection, httpContext, (HttpEntity)byteArrayEntity);
    }

    private void sendResponseOk(VegaHttpServerConnection vegaHttpServerConnection, HttpContext httpContext) throws HttpException, IOException {
        this.sendResponseOk(vegaHttpServerConnection, httpContext, null);
    }

    private void sendResponseOk(VegaHttpServerConnection vegaHttpServerConnection, HttpContext httpContext, HttpEntity httpEntity) throws HttpException, IOException {
        ProtocolVersion protocolVersion = new ProtocolVersion("HTTP", 1, 0);
        HttpResponse httpResponse = this.responseFactory.newHttpResponse(protocolVersion, 200, httpContext);
        if (httpEntity != null) {
            httpResponse.setEntity(httpEntity);
        }
        this.processor.process(httpResponse, httpContext);
        vegaHttpServerConnection.sendResponseHeader(httpResponse);
        vegaHttpServerConnection.sendResponseEntity(httpResponse);
        vegaHttpServerConnection.flush();
    }

    private SSLSocket createSSLSocketForHost(HttpHost httpHost, Socket socket) throws IOException {
        SSLContext sSLContext = this.sslContextRepository.getContextForName(httpHost.getHostName());
        if (sSLContext == null) {
            throw new IOException("Failed to create SSLContext for host " + httpHost.getHostName());
        }
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, httpHost.getHostName(), httpHost.getPort(), true);
        sSLSocket.setUseClientMode(false);
        return sSLSocket;
    }

    private boolean isConnectMethodRequest(HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getMethod();
        return string != null && string.equalsIgnoreCase("CONNECT");
    }

    private boolean isCertificateDownload(HttpRequest httpRequest) {
        return httpRequest.getRequestLine().getUri().toLowerCase().equals("http://vega/ca.crt");
    }
}

