/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.api.http.proxy.IProxyTransaction;
import com.subgraph.vega.api.http.proxy.IProxyTransactionEventHandler;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestTask;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.internal.http.proxy.HttpInterceptor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public class ProxyTransaction
implements IProxyTransaction {
    private final IHttpRequestEngine requestEngine;
    private final HttpContext context;
    private IProxyTransactionEventHandler eventHandler;
    private HttpUriRequest request;
    private IHttpResponse response;
    private HttpInterceptor interceptor;
    private IHttpRequestTask requestTask;
    private boolean isPending = false;
    private boolean doForward = false;
    private Lock lock = new ReentrantLock();
    private Condition cv = this.lock.newCondition();

    ProxyTransaction(IHttpRequestEngine iHttpRequestEngine, HttpContext httpContext) {
        this.requestEngine = iHttpRequestEngine;
        this.context = httpContext;
    }

    public IHttpRequestEngine getRequestEngine() {
        return this.requestEngine;
    }

    public HttpContext getContext() {
        return this.context;
    }

    public synchronized void setResponse(IHttpResponse iHttpResponse) {
        this.response = iHttpResponse;
    }

    public void await() throws InterruptedException {
        this.lock.lock();
        try {
            try {
                while (this.isPending) {
                    this.cv.await();
                }
            }
            catch (InterruptedException interruptedException) {
                try {
                    if (this.interceptor != null) {
                        this.interceptor.notifyHandled(this);
                        this.interceptor = null;
                    }
                }
                finally {
                    this.isPending = false;
                    this.doForward = false;
                }
                throw interruptedException;
            }
        }
        finally {
            try {
                if (this.interceptor != null) {
                    this.interceptor.notifyHandled(this);
                    this.interceptor = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public synchronized void setPending(HttpInterceptor httpInterceptor) {
        this.interceptor = httpInterceptor;
        this.isPending = true;
        this.doForward = false;
    }

    public synchronized void setUnqueued() {
        this.interceptor = null;
    }

    public synchronized boolean getForward() {
        return this.doForward;
    }

    public synchronized void setEventHandler(IProxyTransactionEventHandler iProxyTransactionEventHandler) {
        this.eventHandler = iProxyTransactionEventHandler;
    }

    public synchronized void setRequest(HttpUriRequest httpUriRequest) {
        this.request = httpUriRequest;
    }

    public synchronized boolean hasRequest() {
        return this.request != null;
    }

    public synchronized HttpUriRequest getRequest() {
        return this.request;
    }

    public synchronized boolean hasResponse() {
        return this.response != null;
    }

    public synchronized IHttpResponse getResponse() {
        return this.response;
    }

    public void doForward() {
        this.lock.lock();
        try {
            if (this.isPending) {
                this.isPending = false;
                this.doForward = true;
                this.cv.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void doDrop() {
        this.lock.lock();
        try {
            if (this.isPending) {
                this.isPending = false;
                this.doForward = false;
                this.cv.signal();
            } else if (this.requestTask != null) {
                this.requestTask.abort();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized void signalForward() {
        if (this.eventHandler != null) {
            this.eventHandler.notifyForward();
        }
    }

    public synchronized void signalComplete(boolean bl) {
        if (this.eventHandler != null) {
            this.eventHandler.notifyComplete(bl);
        }
    }

    public synchronized void setRequestTask(IHttpRequestTask iHttpRequestTask) {
        this.requestTask = iHttpRequestTask;
    }
}

