/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.subgraph.vega.internal.sslprobe.CertificateAnalyzer;
import com.subgraph.vega.internal.sslprobe.CipherSuites;
import com.subgraph.vega.internal.sslprobe.ProbeBase;
import com.subgraph.vega.internal.sslprobe.SSL2Protocol;
import com.subgraph.vega.internal.sslprobe.SSLServerScanResult;
import com.subgraph.vega.internal.sslprobe.SSLv2CipherSpec;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public class SSLv2Probe
extends ProbeBase<Void> {
    private static final Logger logger = Logger.getLogger(SSLv2Probe.class.getName());

    SSLv2Probe(SSLServerScanResult sSLServerScanResult) {
        super(sSLServerScanResult);
    }

    @Override
    public Void runProbe() throws IOException {
        SSL2Protocol sSL2Protocol = new SSL2Protocol(this.getInputStream(), this.getOutputStream());
        sSL2Protocol.sendClientHello(CipherSuites.getV2CipherSuites());
        ByteBuffer byteBuffer = sSL2Protocol.getNextHandshakeMessage();
        if (byteBuffer != null) {
            this.processResponse(byteBuffer);
        } else {
            logger.warning("Got EOF receiving SSLv2 Server Hello message");
        }
        return null;
    }

    private void processResponse(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        if (n != 4) {
            logger.warning("Expecting SSLv2 Server Hello message (type = 0x04), but got type = " + n);
            return;
        }
        byteBuffer.get();
        byteBuffer.get();
        byteBuffer.getShort();
        int n2 = byteBuffer.getShort() & 0xFFFF;
        int n3 = byteBuffer.getShort() & 0xFFFF;
        byteBuffer.getShort();
        this.processCertificate(byteBuffer, n2);
        this.processCiphers(byteBuffer, n3);
    }

    private void processCertificate(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        CertificateAnalyzer certificateAnalyzer = new CertificateAnalyzer();
        try {
            X509Certificate x509Certificate = X509Certificate.getInstance(byArray);
            certificateAnalyzer.addCert(x509Certificate);
        }
        catch (CertificateException certificateException) {
            certificateAnalyzer.setError(true);
        }
        this.scanResult.addServerCertificate(certificateAnalyzer);
    }

    private void processCiphers(ByteBuffer byteBuffer, int n) {
        ArrayList<SSLv2CipherSpec> arrayList = new ArrayList<SSLv2CipherSpec>();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.unpackCipherConstant(byteBuffer);
            SSLv2CipherSpec sSLv2CipherSpec = CipherSuites.lookupSSLv2Cipher(n3);
            if (sSLv2CipherSpec != null) {
                arrayList.add(sSLv2CipherSpec);
            }
            n2 += 3;
        }
        this.scanResult.setFlag(SSLServerScanResult.Flag.SSLV2);
        this.scanResult.setServerSSLv2Ciphers(arrayList);
    }

    private int unpackCipherConstant(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[3];
        byteBuffer.get(byArray);
        return (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
    }
}

