/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import org.sleuthkit.datamodel.TskData;

public class TagName
implements Comparable<TagName>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long id;
    private final String displayName;
    private final String description;
    private final HTML_COLOR color;
    private final TskData.FileKnown knownStatus;

    TagName(long id, String displayName, String description, HTML_COLOR color, TskData.FileKnown knownStatus) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.color = color;
        this.knownStatus = knownStatus;
    }

    public long getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public HTML_COLOR getColor() {
        return this.color;
    }

    public TskData.FileKnown getKnownStatus() {
        return this.knownStatus;
    }

    @Override
    public int compareTo(TagName other) {
        return this.getDisplayName().compareTo(other.getDisplayName());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (int)(this.id ^ this.id >>> 32);
        hash = 89 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
        hash = 89 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 89 * hash + (this.color != null ? this.color.hashCode() : 0);
        hash = 89 * hash + (this.knownStatus != null ? this.knownStatus.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagName other = (TagName)obj;
        return this.id == other.id && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.color, (Object)other.color) && Objects.equals((Object)this.knownStatus, (Object)other.knownStatus);
    }

    public static enum HTML_COLOR {
        NONE("None"),
        WHITE("White"),
        SILVER("Silver"),
        GRAY("Gray"),
        BLACK("Black"),
        RED("Red"),
        MAROON("Maron"),
        YELLOW("Yellow"),
        OLIVE("Olive"),
        LIME("Lime"),
        GREEN("Green"),
        AQUA("Aqua"),
        TEAL("Teal"),
        BLUE("Blue"),
        NAVY("Navy"),
        FUCHSIA("Fuchsia"),
        PURPLE("Purple");

        private static final HashMap<String, HTML_COLOR> colorMap;
        private final String name;

        private HTML_COLOR(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        public static HTML_COLOR getColorByName(String colorName) {
            if (colorMap.containsKey(colorName)) {
                return colorMap.get(colorName);
            }
            return NONE;
        }

        static {
            colorMap = new HashMap();
            for (HTML_COLOR color : HTML_COLOR.values()) {
                colorMap.put(color.name(), color);
            }
        }
    }
}

